/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.sponge;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import com.google.inject.Inject;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.Server;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.Caches;
import de.bluecolored.bluemap.sponge.EventForwarder;
import de.bluecolored.bluemap.sponge.Log4J2Logger;
import de.bluecolored.bluemap.sponge.SpongeCommands;
import de.bluecolored.bluemap.sponge.SpongePlayer;
import de.bluecolored.bluemap.sponge.SpongeWorld;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.RefreshGameEvent;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.StartedEngineEvent;
import org.spongepowered.api.event.lifecycle.StoppingEngineEvent;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;

@Plugin(value="bluemap")
public class SpongePlugin
implements Server {
    private static SpongePlugin instance;
    private final PluginContainer pluginContainer;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configurationDir;
    private final de.bluecolored.bluemap.common.plugin.Plugin pluginInstance;
    private final SpongeCommands commands;
    private ExecutorService asyncExecutor;
    private ExecutorService syncExecutor;
    private int playerUpdateIndex = 0;
    private final Map<UUID, Player> onlinePlayerMap;
    private final List<SpongePlayer> onlinePlayerList;
    private final LoadingCache<org.spongepowered.api.world.server.ServerWorld, ServerWorld> worlds;

    @Inject
    public SpongePlugin(org.apache.logging.log4j.Logger logger, PluginContainer pluginContainer) {
        Logger.global.clear();
        Logger.global.put(new Log4J2Logger(logger));
        this.pluginContainer = pluginContainer;
        this.onlinePlayerMap = new ConcurrentHashMap<UUID, Player>();
        this.onlinePlayerList = Collections.synchronizedList(new ArrayList());
        this.pluginInstance = new de.bluecolored.bluemap.common.plugin.Plugin("sponge", this);
        this.commands = new SpongeCommands(this.pluginInstance);
        this.worlds = Caches.with().weakKeys().maximumSize(1000L).build(SpongeWorld::new);
        instance = this;
    }

    @Listener
    public void onRegisterCommands(RegisterCommandEvent<Command.Raw> event) {
        for (SpongeCommands.SpongeCommandProxy command : this.commands.getRootCommands()) {
            event.register(this.pluginContainer, (Object)command, command.getLabel(), new String[0]);
        }
    }

    @Listener
    public void onServerStart(StartedEngineEvent<org.spongepowered.api.Server> evt) {
        this.asyncExecutor = evt.game().asyncScheduler().executor(this.pluginContainer);
        this.syncExecutor = ((org.spongepowered.api.Server)evt.engine()).scheduler().executor(this.pluginContainer);
        Task task = Task.builder().interval(Ticks.of((long)1L)).execute(this::updateSomePlayers).plugin(this.pluginContainer).build();
        ((org.spongepowered.api.Server)evt.engine()).scheduler().submit(task);
        this.asyncExecutor.execute(() -> {
            try {
                Logger.global.logInfo("Loading...");
                this.pluginInstance.load();
                if (this.pluginInstance.isLoaded()) {
                    Logger.global.logInfo("Loaded!");
                }
            }
            catch (IOException | RuntimeException e) {
                Logger.global.logError("Failed to load!", e);
                this.pluginInstance.unload();
            }
        });
    }

    @Listener
    public void onServerStop(StoppingEngineEvent<org.spongepowered.api.Server> evt) {
        Logger.global.logInfo("Stopping...");
        ((org.spongepowered.api.Server)evt.engine()).scheduler().tasks(this.pluginContainer).forEach(ScheduledTask::cancel);
        this.pluginInstance.unload();
        Logger.global.logInfo("Saved and stopped!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onServerReload(RefreshGameEvent evt) {
        this.asyncExecutor.execute(() -> {
            try {
                Logger.global.logInfo("Reloading...");
                this.pluginInstance.reload();
                Logger.global.logInfo("Reloaded!");
            }
            catch (IOException | RuntimeException e) {
                Logger.global.logError("Failed to load!", e);
                this.pluginInstance.unload();
            }
        });
        this.onlinePlayerMap.clear();
        List<SpongePlayer> list = this.onlinePlayerList;
        synchronized (list) {
            this.onlinePlayerList.clear();
            for (ServerPlayer spongePlayer : Sponge.server().onlinePlayers()) {
                SpongePlayer player = new SpongePlayer(spongePlayer);
                this.onlinePlayerMap.put(spongePlayer.uniqueId(), player);
                this.onlinePlayerList.add(player);
            }
        }
    }

    @Listener
    public void onPlayerJoin(ServerSideConnectionEvent.Join evt) {
        SpongePlayer player = new SpongePlayer(evt.player());
        this.onlinePlayerMap.put(evt.player().uniqueId(), player);
        this.onlinePlayerList.add(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onPlayerLeave(ServerSideConnectionEvent.Leave evt) {
        UUID playerUUID = evt.player().uniqueId();
        this.onlinePlayerMap.remove(playerUUID);
        List<SpongePlayer> list = this.onlinePlayerList;
        synchronized (list) {
            this.onlinePlayerList.removeIf(p -> p.getUuid().equals(playerUUID));
        }
    }

    @Override
    public String getMinecraftVersion() {
        return Sponge.platform().minecraftVersion().name();
    }

    @Override
    public void registerListener(ServerEventListener listener) {
        Sponge.eventManager().registerListeners(this.pluginContainer, (Object)new EventForwarder(listener));
    }

    @Override
    public void unregisterAllListeners() {
        Sponge.eventManager().unregisterListeners((Object)this.pluginContainer);
        Sponge.eventManager().registerListeners(this.pluginContainer, (Object)this);
    }

    @Override
    public Collection<ServerWorld> getLoadedServerWorlds() {
        ArrayList<ServerWorld> loadedWorlds = new ArrayList<ServerWorld>(3);
        for (org.spongepowered.api.world.server.ServerWorld world : Sponge.server().worldManager().worlds()) {
            loadedWorlds.add(this.worlds.get(world));
        }
        return loadedWorlds;
    }

    @Override
    public Optional<ServerWorld> getServerWorld(Object world) {
        org.spongepowered.api.world.server.ServerWorld serverWorld;
        if (world instanceof String) {
            ResourceKey resourceKey = ResourceKey.resolve((String)((String)world));
            org.spongepowered.api.world.server.ServerWorld serverWorld2 = Sponge.server().worldManager().world(resourceKey).orElse(null);
            if (serverWorld2 != null) {
                world = serverWorld2;
            }
        }
        if (world instanceof ResourceKey && (serverWorld = (org.spongepowered.api.world.server.ServerWorld)Sponge.server().worldManager().world((ResourceKey)world).orElse(null)) != null) {
            world = serverWorld;
        }
        if (world instanceof org.spongepowered.api.world.server.ServerWorld) {
            return Optional.of(this.getServerWorld((org.spongepowered.api.world.server.ServerWorld)world));
        }
        return Optional.empty();
    }

    public ServerWorld getServerWorld(org.spongepowered.api.world.server.ServerWorld world) {
        return this.worlds.get(Objects.requireNonNull(world));
    }

    @Override
    public Path getConfigFolder() {
        return this.configurationDir;
    }

    @Override
    public Optional<Path> getModsFolder() {
        return Optional.of(Path.of("mods", new String[0]));
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        return this.onlinePlayerMap.values();
    }

    @Override
    public de.bluecolored.bluemap.core.util.Tristate isMetricsEnabled() {
        Tristate metricsEnabled;
        if (this.pluginContainer != null && (metricsEnabled = Sponge.metricsConfigManager().collectionState(this.pluginContainer)) != Tristate.UNDEFINED) {
            if (metricsEnabled == Tristate.TRUE) {
                return de.bluecolored.bluemap.core.util.Tristate.TRUE;
            }
            return de.bluecolored.bluemap.core.util.Tristate.FALSE;
        }
        return Sponge.metricsConfigManager().globalCollectionState() == Tristate.TRUE ? de.bluecolored.bluemap.core.util.Tristate.TRUE : de.bluecolored.bluemap.core.util.Tristate.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSomePlayers() {
        List<SpongePlayer> list = this.onlinePlayerList;
        synchronized (list) {
            int onlinePlayerCount = this.onlinePlayerList.size();
            if (onlinePlayerCount == 0) {
                return;
            }
            int playersToBeUpdated = onlinePlayerCount / 20;
            if (playersToBeUpdated == 0) {
                playersToBeUpdated = 1;
            }
            for (int i = 0; i < playersToBeUpdated; ++i) {
                ++this.playerUpdateIndex;
                if (this.playerUpdateIndex >= 20 && this.playerUpdateIndex >= onlinePlayerCount) {
                    this.playerUpdateIndex = 0;
                }
                if (this.playerUpdateIndex >= onlinePlayerCount) continue;
                this.onlinePlayerList.get(this.playerUpdateIndex).update();
            }
        }
    }

    public static com.flowpowered.math.vector.Vector3d fromSpongeVector(Vector3d vec) {
        return new com.flowpowered.math.vector.Vector3d(vec.x(), vec.y(), vec.z());
    }

    public static Vector3i fromSpongeVector(org.spongepowered.math.vector.Vector3i vec) {
        return new Vector3i(vec.x(), vec.y(), vec.z());
    }

    public static Vector2i fromSpongeVector(org.spongepowered.math.vector.Vector2i vec) {
        return new Vector2i(vec.x(), vec.y());
    }

    public ExecutorService getSyncExecutor() {
        return this.syncExecutor;
    }

    public de.bluecolored.bluemap.common.plugin.Plugin getPlugin() {
        return this.pluginInstance;
    }

    public static SpongePlugin getInstance() {
        return instance;
    }
}

