/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.sponge;

import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.sponge.SpongePlugin;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.spongepowered.api.world.WorldTypes;
import org.spongepowered.api.world.server.ServerWorld;

public class SpongeWorld
implements de.bluecolored.bluemap.common.serverinterface.ServerWorld {
    private final WeakReference<ServerWorld> delegate;
    private final Path worldFolder;
    private final Key dimension;

    public SpongeWorld(ServerWorld delegate) {
        this.delegate = new WeakReference<ServerWorld>(delegate);
        Path dimensionFolder = delegate.directory().normalize();
        this.dimension = WorldTypes.registry().findValueKey((Object)delegate.worldType()).map(k -> new Key(k.namespace(), k.value())).orElse(DataPack.DIMENSION_OVERWORLD);
        this.worldFolder = DataPack.DIMENSION_OVERWORLD.equals(this.dimension) ? dimensionFolder : (DataPack.DIMENSION_THE_NETHER.equals(this.dimension) || DataPack.DIMENSION_THE_END.equals(this.dimension) ? dimensionFolder.getParent() : dimensionFolder.getParent().getParent().getParent());
    }

    @Override
    public boolean persistWorldChanges() throws IOException {
        ServerWorld delegateWorld = (ServerWorld)this.delegate.get();
        if (delegateWorld == null) {
            return false;
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return delegateWorld.save();
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
            }, SpongePlugin.getInstance().getSyncExecutor()).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwable t2 = e.getCause();
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            throw new IOException(t2);
        }
    }

    @Override
    public Path getWorldFolder() {
        return this.worldFolder;
    }

    @Override
    public Key getDimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeWorld that = (SpongeWorld)o;
        Object world = this.delegate.get();
        return world != null && world.equals(that.delegate.get());
    }

    public int hashCode() {
        Object world = this.delegate.get();
        return world != null ? world.hashCode() : 0;
    }
}

