/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.UnaryOperator;

@FunctionalInterface
public interface NamingStrategy
extends Function<Field, String> {
    public static final NamingStrategy FIELD_NAME = Field::getName;
    public static final NamingStrategy LOWER_CASE = field -> field.getName().toLowerCase();
    public static final NamingStrategy UPPER_CASE = field -> field.getName().toUpperCase();
    public static final NamingStrategy UPPER_CAMEL_CASE = field -> NamingStrategy.transformFirstLetter(field.getName(), Character::toUpperCase);

    @Override
    public String apply(Field var1);

    public static NamingStrategy lowerCaseWithDelimiter(String delimiter) {
        return field -> String.join((CharSequence)delimiter, NamingStrategy.splitCamelCase(field.getName())).toLowerCase();
    }

    public static NamingStrategy upperCaseWithDelimiter(String delimiter) {
        return field -> String.join((CharSequence)delimiter, NamingStrategy.splitCamelCase(field.getName())).toUpperCase();
    }

    public static String[] splitCamelCase(String input) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        for (int i = 1; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            result.add(input.substring(start, i));
            start = i;
        }
        result.add(input.substring(start));
        return (String[])result.toArray(String[]::new);
    }

    public static String transformFirstLetter(String input, UnaryOperator<Character> operation) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isLetter(c)) continue;
            return input.substring(0, i) + String.valueOf(operation.apply(Character.valueOf(c))) + input.substring(i + 1);
        }
        return input;
    }
}

