/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.airlift.compress.zstd;

import de.bluecolored.shadow.airlift.compress.Decompressor;
import de.bluecolored.shadow.airlift.compress.MalformedInputException;
import de.bluecolored.shadow.airlift.compress.zstd.UnsafeUtil;
import de.bluecolored.shadow.airlift.compress.zstd.ZstdFrameDecompressor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import sun.misc.Unsafe;

public class ZstdDecompressor
implements Decompressor {
    private final ZstdFrameDecompressor decompressor = new ZstdFrameDecompressor();

    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        ZstdDecompressor.verifyRange(input, inputOffset, inputLength);
        ZstdDecompressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return this.decompressor.decompress(input, inputAddress, inputLimit, output, outputAddress, outputLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(ByteBuffer inputBuffer, ByteBuffer outputBuffer) throws MalformedInputException {
        long outputLimit;
        long outputAddress;
        Object outputBase;
        long inputLimit;
        long inputAddress;
        Object inputBase;
        ByteBuffer input = inputBuffer;
        ByteBuffer output = outputBuffer;
        if (((Buffer)input).isDirect()) {
            inputBase = null;
            long address = UnsafeUtil.getAddress(input);
            inputAddress = address + (long)input.position();
            inputLimit = address + (long)input.limit();
        } else if (((Buffer)input).hasArray()) {
            inputBase = ((Buffer)input).array();
            inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)input).arrayOffset() + input.position();
            inputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)input).arrayOffset() + input.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + input.getClass().getName());
        }
        if (((Buffer)output).isDirect()) {
            outputBase = null;
            long address = UnsafeUtil.getAddress(output);
            outputAddress = address + (long)output.position();
            outputLimit = address + (long)output.limit();
        } else if (((Buffer)output).hasArray()) {
            outputBase = ((Buffer)output).array();
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)output).arrayOffset() + output.position();
            outputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + ((Buffer)output).arrayOffset() + output.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + output.getClass().getName());
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = output;
            synchronized (byteBuffer2) {
                int written = this.decompressor.decompress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit);
                ((Buffer)output).position(output.position() + written);
            }
        }
    }

    public static long getDecompressedSize(byte[] input, int offset, int length) {
        int baseAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        return ZstdFrameDecompressor.getDecompressedSize(input, baseAddress, baseAddress + length);
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

