/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands;

import de.bluecolored.bluecommands.Command;
import de.bluecolored.bluecommands.CommandParseException;
import de.bluecolored.bluecommands.CommandSetupException;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.ParseData;
import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.Suggestion;
import de.bluecolored.bluecommands.parsers.ArgumentParser;
import java.util.List;

public class ArgumentCommand<C, T>
extends Command<C, T> {
    private final String argumentId;
    private final ArgumentParser<C, ?> argumentParser;
    private final boolean optional;

    public ArgumentCommand(String argumentId, ArgumentParser<C, ?> argumentParser, boolean optional) {
        this.argumentId = argumentId;
        this.argumentParser = argumentParser;
        this.optional = optional;
    }

    public String getArgumentId() {
        return this.argumentId;
    }

    public ArgumentParser<C, ?> getArgumentParser() {
        return this.argumentParser;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    void parse(ParseData<C, T> data) {
        C context = data.getContext();
        if (!this.isValid(context)) {
            return;
        }
        InputReader input = data.getInput();
        int position = input.getPosition();
        int matchCount = data.getResult().getMatches().size();
        try {
            Object argument = this.argumentParser.parse(context, input);
            if (input.getPosition() < position) {
                throw new CommandSetupException("The ArgumentParser '" + this.argumentParser + "' altered the InputReader in an illegal way. (position changed backwards)");
            }
            int next = input.peek();
            if (next != -1 && next != 32) {
                throw new CommandSetupException("The ArgumentParser '" + this.argumentParser + "' did not consume the full token. (expected next char to be a space or end of string)");
            }
            if (next == -1) {
                input.setPosition(position);
                List<Suggestion> extraSuggesions = this.argumentParser.suggest(context, input);
                if (!extraSuggesions.isEmpty()) {
                    data.getResult().addFailure(new ParseFailure<C, T>(position, "Alternative Usages", data.getCommandStack(), extraSuggesions));
                }
                input.readRemaining();
            }
            data.getCurrentSegment().setValue(argument);
            super.parse(data);
        }
        catch (CommandParseException ex) {
            input.setPosition(position);
            data.getResult().addFailure(new ParseFailure<C, T>(position, ex.getMessage(), data.getCommandStack(), this.argumentParser.suggest(context, input)));
        }
        if (this.optional && matchCount == data.getResult().getMatches().size()) {
            data.getCurrentSegment().setValue(null);
            input.setPosition(Math.max(0, position - 1));
            super.parse(data);
        }
    }

    @Override
    public boolean isEqual(Command<C, T> other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ArgumentCommand ac = (ArgumentCommand)other;
        return ac.optional == this.optional && ac.argumentId.equals(this.argumentId) && ac.argumentParser.equals(this.argumentParser);
    }
}

