/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands;

import java.io.Reader;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputReader
extends Reader {
    private final String input;
    private final int length;
    private int position = 0;
    private int mark = 0;

    public InputReader(String input) {
        this.input = input;
        this.length = input.length();
    }

    @Override
    public int read() {
        if (this.position >= this.length) {
            return -1;
        }
        return this.input.charAt(this.position++);
    }

    public int peek() {
        if (this.position >= this.length) {
            return -1;
        }
        return this.input.charAt(this.position);
    }

    @Override
    public int read(char @NotNull [] charBuffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, charBuffer.length);
        if (length == 0) {
            return 0;
        }
        if (this.position >= this.length) {
            return -1;
        }
        int count = Math.min(this.length - this.position, length);
        this.input.getChars(this.position, this.position + count, charBuffer, offset);
        this.position += count;
        return count;
    }

    @Override
    public int read(char @NotNull [] charBuffer) {
        return this.read(charBuffer, 0, charBuffer.length);
    }

    @Nullable
    public MatchResult read(@NotNull Pattern pattern) {
        MatchResult result = this.peek(pattern);
        if (result != null) {
            this.position = result.end();
        }
        return result;
    }

    @Nullable
    public MatchResult peek(@NotNull Pattern pattern) {
        Matcher matcher = pattern.matcher(this.input);
        matcher.region(this.position, this.length);
        if (matcher.find() && matcher.start() == this.position) {
            return matcher;
        }
        return null;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public long skip(long n) {
        if (this.position >= this.length) {
            return 0L;
        }
        long r = Math.min((long)(this.length - this.position), n);
        r = Math.max((long)(-this.position), r);
        this.position = (int)((long)this.position + r);
        return r;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark();
    }

    public void mark() {
        this.mark = this.position;
    }

    @Override
    public void reset() {
        this.position = this.mark;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getRemaining() {
        return this.length - this.position;
    }

    public String peekRemaining() {
        return this.input.substring(this.position);
    }

    public String readRemaining() {
        String remaining = this.peekRemaining();
        this.position = this.length;
        return remaining;
    }

    public String getInput() {
        return this.input;
    }

    @Override
    public void close() {
    }
}

