/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.bukkit;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.bukkit.BukkitPlugin;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.shadow.adventure.adventure.text.Component;
import de.bluecolored.shadow.adventure.adventure.text.TextComponent;
import de.bluecolored.shadow.adventure.adventure.text.serializer.gson.GsonComponentSerializer;
import java.util.Optional;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class BukkitCommandSource
implements CommandSource {
    private final CommandSender delegate;

    public BukkitCommandSource(CommandSender delegate) {
        this.delegate = delegate;
    }

    @Override
    public void sendMessage(Component text) {
        if (TextFormat.lineCount(text) > 1) {
            text = ((TextComponent)Component.newline().append(text)).appendNewline();
        }
        this.delegate.spigot().sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.gson().serialize(text.compact()))));
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.delegate.hasPermission(permission);
    }

    @Override
    public Optional<Vector3d> getPosition() {
        Location location = this.getLocation();
        if (location != null) {
            return Optional.of(new Vector3d(location.getX(), location.getY(), location.getZ()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ServerWorld> getWorld() {
        Location location = this.getLocation();
        if (location != null) {
            World world = location.getWorld();
            if (world == null) {
                return Optional.empty();
            }
            return Optional.of(BukkitPlugin.getInstance().getServerWorld(world));
        }
        return Optional.empty();
    }

    private Location getLocation() {
        Location location = null;
        if (this.delegate instanceof Entity) {
            location = ((Entity)this.delegate).getLocation();
        }
        if (this.delegate instanceof BlockCommandSender) {
            location = ((BlockCommandSender)this.delegate).getBlock().getLocation();
        }
        return location;
    }
}

