/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.bukkit;

import de.bluecolored.bluecommands.Command;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.LiteralCommand;
import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.ParseResult;
import de.bluecolored.bluecommands.Suggestion;
import de.bluecolored.bluemap.bukkit.BukkitCommandSource;
import de.bluecolored.bluemap.common.commands.CommandExecutor;
import de.bluecolored.bluemap.common.commands.Commands;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.shadow.adventure.adventure.text.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;
import org.jetbrains.annotations.NotNull;

public class BukkitCommands
implements Listener {
    private final Command<CommandSource, Object> commands;
    private final CommandExecutor commandExecutor;

    public BukkitCommands(Plugin plugin) {
        this.commands = Commands.create(plugin);
        this.commandExecutor = new CommandExecutor(plugin);
    }

    public Collection<? extends BukkitCommand> getRootCommands() {
        return List.of(new CommandProxy(((LiteralCommand)this.commands).getLiteral()));
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent evt) {
        String input = evt.getBuffer();
        if (!input.isEmpty() && input.charAt(0) == '/') {
            input = input.substring(1);
        }
        int position = input.lastIndexOf(32) + 1;
        InputReader inputReader = new InputReader(input);
        inputReader.setPosition(position);
        BukkitCommandSource context = new BukkitCommandSource(evt.getSender());
        ParseResult<CommandSource, Object> result = this.commands.parse((CommandSource)context, input);
        ArrayList<String> completions = new ArrayList<String>();
        for (ParseFailure<CommandSource, Object> failure : result.getFailures()) {
            if (failure.getPosition() != position) continue;
            for (Suggestion suggestion : failure.getSuggestions()) {
                completions.add(suggestion.getString());
            }
        }
        if (!completions.isEmpty()) {
            completions.sort(String::compareToIgnoreCase);
            try {
                evt.getCompletions().addAll(completions);
            }
            catch (UnsupportedOperationException ex) {
                ArrayList<String> mutableCompletions = new ArrayList<String>(evt.getCompletions());
                mutableCompletions.addAll(completions);
                evt.setCompletions(mutableCompletions);
            }
        }
    }

    private class CommandProxy
    extends BukkitCommand {
        protected CommandProxy(String name) {
            super(name);
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
            BukkitCommandSource context;
            ParseResult<CommandSource, Object> result;
            CommandExecutor.ExecutionResult executionResult;
            Object input = commandLabel;
            if (args.length > 0) {
                input = (String)input + " " + String.join((CharSequence)" ", args);
            }
            if ((executionResult = BukkitCommands.this.commandExecutor.execute(result = BukkitCommands.this.commands.parse((CommandSource)(context = new BukkitCommandSource(sender)), (String)input))).parseFailure()) {
                Optional<ParseFailure> failure = result.getFailures().stream().max(Comparator.comparing(ParseFailure::getPosition));
                if (failure.isPresent()) {
                    context.sendMessage(Component.text(failure.get().getReason()).color(TextFormat.NEGATIVE_COLOR));
                } else {
                    context.sendMessage(Component.text("Unknown command!").color(TextFormat.NEGATIVE_COLOR));
                }
                return false;
            }
            return executionResult.resultCode() > 0;
        }
    }
}

