/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.bukkit;

import de.bluecolored.bluemap.bukkit.BukkitCommands;
import de.bluecolored.bluemap.bukkit.BukkitPlayer;
import de.bluecolored.bluemap.bukkit.BukkitWorld;
import de.bluecolored.bluemap.bukkit.EventForwarder;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.Server;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.JavaLogger;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.shadow.bstats.bukkit.Metrics;
import de.bluecolored.shadow.caffeine.cache.Caffeine;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlugin
extends JavaPlugin
implements Server,
Listener {
    private static BukkitPlugin instance;
    private final Plugin pluginInstance;
    private final EventForwarder eventForwarder;
    private final BukkitCommands commands;
    private final String minecraftVersion;
    private int playerUpdateIndex = 0;
    private final Map<UUID, Player> onlinePlayerMap;
    private final List<BukkitPlayer> onlinePlayerList;
    private final LoadingCache<World, ServerWorld> worlds;

    public BukkitPlugin() {
        Logger.global.clear();
        Logger.global.put(new JavaLogger(this.getLogger()));
        String version = null;
        try {
            String versionString = this.getServer().getBukkitVersion();
            Matcher versionMatcher = Pattern.compile("(\\d+(?:\\.\\d+){1,2})[-_].*").matcher(versionString);
            if (!versionMatcher.matches()) {
                throw new IllegalArgumentException();
            }
            version = versionMatcher.group(1);
            if (version.endsWith(".0")) {
                version = version.substring(0, version.length() - 2);
            }
        }
        catch (IllegalArgumentException e) {
            Logger.global.logWarning("Failed to detect the minecraft version of this server! Using latest version.");
        }
        this.minecraftVersion = version;
        this.onlinePlayerMap = new ConcurrentHashMap<UUID, Player>();
        this.onlinePlayerList = Collections.synchronizedList(new ArrayList());
        this.eventForwarder = new EventForwarder();
        this.pluginInstance = new Plugin("spigot", this);
        this.commands = new BukkitCommands(this.pluginInstance);
        this.worlds = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).weakKeys().maximumSize(1000L).build(BukkitWorld::new);
        instance = this;
    }

    public void onEnable() {
        Logger.global.logInfo("Saving all worlds once, to make sure the level.dat is present...");
        for (World world : this.getServer().getWorlds()) {
            world.save();
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (org.bukkit.plugin.Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.eventForwarder, (org.bukkit.plugin.Plugin)this);
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            for (BukkitCommand bukkitCommand : this.commands.getRootCommands()) {
                commandMap.register("bluemap", (Command)bukkitCommand);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            Logger.global.logError("Failed to register commands!", e);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.commands, (org.bukkit.plugin.Plugin)this);
        this.onlinePlayerList.clear();
        this.onlinePlayerMap.clear();
        for (org.bukkit.entity.Player player : this.getServer().getOnlinePlayers()) {
            BukkitPlayer bukkitPlayer = new BukkitPlayer(player);
            this.onlinePlayerMap.put(player.getUniqueId(), bukkitPlayer);
            this.onlinePlayerList.add(bukkitPlayer);
        }
        this.getServer().getScheduler().runTaskAsynchronously((org.bukkit.plugin.Plugin)this, () -> {
            try {
                Logger.global.logInfo("Loading...");
                this.pluginInstance.load();
                if (this.pluginInstance.isLoaded()) {
                    Logger.global.logInfo("Loaded!");
                }
                this.getServer().getScheduler().runTaskTimer((org.bukkit.plugin.Plugin)this, this::updateSomePlayers, 1L, 1L);
            }
            catch (IOException | RuntimeException e) {
                Logger.global.logError("Failed to load!", e);
                this.pluginInstance.unload();
            }
        });
        new Metrics(this, 5912);
    }

    public void onDisable() {
        Logger.global.logInfo("Stopping...");
        this.getServer().getScheduler().cancelTasks((org.bukkit.plugin.Plugin)this);
        this.pluginInstance.unload();
        Logger.global.logInfo("Saved and stopped!");
    }

    @Override
    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    public void registerListener(ServerEventListener listener) {
        this.eventForwarder.addListener(listener);
    }

    @Override
    public void unregisterAllListeners() {
        this.eventForwarder.removeAllListeners();
    }

    @Override
    public Collection<ServerWorld> getLoadedServerWorlds() {
        ArrayList<ServerWorld> loadedWorlds = new ArrayList<ServerWorld>(3);
        for (World world : Bukkit.getWorlds()) {
            loadedWorlds.add(this.worlds.get(world));
        }
        return loadedWorlds;
    }

    @Override
    public Optional<ServerWorld> getServerWorld(Object world) {
        World serverWorld;
        if (world instanceof String && (serverWorld = Bukkit.getWorld((String)((String)world))) != null) {
            world = serverWorld;
        }
        if (world instanceof String && (serverWorld = Bukkit.getWorld((String)new Key((String)world).getValue())) != null) {
            world = serverWorld;
        }
        if (world instanceof UUID && (serverWorld = Bukkit.getWorld((UUID)((UUID)world))) != null) {
            world = serverWorld;
        }
        if (world instanceof World) {
            return Optional.of(this.getServerWorld((World)world));
        }
        return Optional.empty();
    }

    public ServerWorld getServerWorld(World world) {
        return this.worlds.get(Objects.requireNonNull(world));
    }

    @Override
    public Path getConfigFolder() {
        return this.getDataFolder().toPath();
    }

    @Override
    public Optional<Path> getModsFolder() {
        return Optional.of(Path.of("mods", new String[0]));
    }

    public Plugin getPlugin() {
        return this.pluginInstance;
    }

    public static BukkitPlugin getInstance() {
        return instance;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent evt) {
        BukkitPlayer player = new BukkitPlayer(evt.getPlayer());
        this.onlinePlayerMap.put(evt.getPlayer().getUniqueId(), player);
        this.onlinePlayerList.add(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLeave(PlayerQuitEvent evt) {
        UUID playerUUID = evt.getPlayer().getUniqueId();
        this.onlinePlayerMap.remove(playerUUID);
        List<BukkitPlayer> list = this.onlinePlayerList;
        synchronized (list) {
            this.onlinePlayerList.removeIf(p -> p.getUuid().equals(playerUUID));
        }
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        return this.onlinePlayerMap.values();
    }

    private void updateSomePlayers() {
        int onlinePlayerCount = this.onlinePlayerList.size();
        if (onlinePlayerCount == 0) {
            return;
        }
        int playersToBeUpdated = onlinePlayerCount / 20;
        if (playersToBeUpdated == 0) {
            playersToBeUpdated = 1;
        }
        for (int i = 0; i < playersToBeUpdated; ++i) {
            ++this.playerUpdateIndex;
            if (this.playerUpdateIndex >= 20 && this.playerUpdateIndex >= onlinePlayerCount) {
                this.playerUpdateIndex = 0;
            }
            if (this.playerUpdateIndex >= onlinePlayerCount) continue;
            this.onlinePlayerList.get(this.playerUpdateIndex).update();
        }
    }
}

