/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.bukkit;

import de.bluecolored.bluemap.bukkit.BukkitPlugin;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class BukkitWorld
implements ServerWorld {
    private final WeakReference<World> delegate;
    private final Path worldFolder;
    private final Key dimension;

    public BukkitWorld(World delegate) {
        this.delegate = new WeakReference<World>(delegate);
        this.dimension = this.resolveDimension(delegate);
        Path worldFolder = delegate.getWorldFolder().toPath();
        Path dimensionFolder = MCAWorld.resolveDimensionFolder(worldFolder, this.dimension);
        if (!Files.exists(worldFolder, new LinkOption[0])) {
            Path dimensionSubPath = worldFolder.relativize(dimensionFolder);
            if (Files.exists(worldFolder, new LinkOption[0]) && worldFolder.endsWith(dimensionSubPath)) {
                worldFolder = worldFolder.subpath(0, worldFolder.getNameCount() - dimensionSubPath.getNameCount());
            }
        }
        this.worldFolder = worldFolder;
    }

    private Key resolveDimension(World world) {
        if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
            return DataPack.DIMENSION_THE_NETHER;
        }
        if (world.getEnvironment().equals((Object)World.Environment.THE_END)) {
            return DataPack.DIMENSION_THE_END;
        }
        return DataPack.DIMENSION_OVERWORLD;
    }

    @Override
    public boolean persistWorldChanges() throws IOException {
        World delegateWorld = (World)this.delegate.get();
        if (delegateWorld == null) {
            return false;
        }
        try {
            return (Boolean)Bukkit.getScheduler().callSyncMethod((Plugin)BukkitPlugin.getInstance(), () -> {
                delegateWorld.save();
                return true;
            }).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwable t2 = e.getCause();
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            throw new IOException(t2);
        }
    }

    @Override
    public Path getWorldFolder() {
        return this.worldFolder;
    }

    @Override
    public Key getDimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BukkitWorld that = (BukkitWorld)o;
        Object world = this.delegate.get();
        return world != null && world.equals(that.delegate.get());
    }

    public int hashCode() {
        Object world = this.delegate.get();
        return world != null ? world.hashCode() : 0;
    }
}

