/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.Unloaded;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.shadow.adventure.adventure.text.Component;
import java.io.IOException;

public class ReloadCommand {
    private final Plugin plugin;

    @Command(value={"reload"})
    @Permission(value="bluemap.reload")
    @Unloaded
    public boolean reload(CommandSource source) {
        return this.reload(source, false);
    }

    @Command(value={"reload light"})
    @Permission(value="bluemap.reload.light")
    @Unloaded
    public boolean reloadLight(CommandSource source) {
        return this.reload(source, true);
    }

    private boolean reload(CommandSource source, boolean light) {
        try {
            source.sendMessage(Component.text("Reloading BlueMap...").color(TextFormat.INFO_COLOR));
            if (light) {
                this.plugin.lightReload();
            } else {
                this.plugin.reload();
            }
            if (this.plugin.isLoaded()) {
                source.sendMessage(Component.text("BlueMap reloaded!").color(TextFormat.POSITIVE_COLOR));
                return true;
            }
            source.sendMessage(Component.text("Could not load BlueMap! See logs or console for details!").color(TextFormat.NEGATIVE_COLOR));
            return false;
        }
        catch (IOException e) {
            Logger.global.logError("Failed to reload BlueMap!", e);
            source.sendMessage(Component.text("There was an error reloading BlueMap! See logs or console for details!").color(TextFormat.NEGATIVE_COLOR));
            return false;
        }
    }

    public ReloadCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

