/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.typeserializer;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import de.bluecolored.shadow.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;

public class Vector2dTypeSerializer
implements TypeSerializer<Vector2d> {
    @Override
    public Vector2d deserialize(Type type, ConfigurationNode node) throws SerializationException {
        ConfigurationNode xNode = node.node("x");
        ConfigurationNode yNode = node.node("y");
        if (yNode.virtual()) {
            yNode = node.node("z");
        }
        if (xNode.virtual() || yNode.virtual()) {
            throw new SerializationException("Cannot parse Vector2d: value x or y (or z) missing");
        }
        return Vector2d.from(xNode.getDouble(), yNode.getDouble());
    }

    @Override
    public void serialize(Type type, @Nullable Vector2d obj, ConfigurationNode node) throws SerializationException {
        if (obj != null) {
            node.node("x").set(obj.getX());
            node.node("y").set(obj.getY());
        }
    }
}

