/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HttpResponse
implements Closeable {
    private static final byte[] CHUNK_SUFFIX = "\r\n".getBytes(StandardCharsets.UTF_8);
    private String version = "HTTP/1.1";
    private HttpStatusCode statusCode;
    private final Map<String, HttpHeader> headers;
    private ReadableByteChannel data;
    private ByteBuffer headerData;
    private ByteBuffer dataBuffer;
    private boolean complete = false;
    private boolean headerComplete = false;
    private boolean dataChannelComplete = false;
    private boolean dataComplete = false;

    public HttpResponse(HttpStatusCode statusCode) {
        this.statusCode = statusCode;
        this.headers = new HashMap<String, HttpHeader>();
    }

    public synchronized boolean read(WritableByteChannel channel) throws IOException {
        if (this.complete) {
            return true;
        }
        if (!this.headerComplete) {
            if (this.headerData == null) {
                this.writeHeaderData();
            }
            if (this.headerData.hasRemaining()) {
                channel.write(this.headerData);
            }
            if (this.headerData.hasRemaining()) {
                return false;
            }
            this.headerComplete = true;
            this.headerData = null;
        }
        if (!this.hasData()) {
            this.complete = true;
            return true;
        }
        if (this.dataBuffer == null) {
            this.dataBuffer = ByteBuffer.allocate(1224).flip();
        }
        while (true) {
            if (this.dataBuffer.hasRemaining()) {
                channel.write(this.dataBuffer);
            }
            if (this.dataBuffer.hasRemaining()) {
                return false;
            }
            if (this.dataComplete) break;
            this.dataBuffer.clear();
            this.dataBuffer.position(100);
            this.dataBuffer.limit(1124);
            int readTotal = 0;
            if (!this.dataChannelComplete) {
                int read = 0;
                while (this.dataBuffer.hasRemaining() && (read = this.data.read(this.dataBuffer)) != -1) {
                    readTotal += read;
                }
                if (read == -1) {
                    this.dataChannelComplete = true;
                }
            }
            if (readTotal == 0) {
                this.dataComplete = true;
            }
            byte[] chunkPrefix = (Integer.toHexString(readTotal) + "\r\n").getBytes(StandardCharsets.UTF_8);
            this.dataBuffer.limit(this.dataBuffer.capacity());
            this.dataBuffer.put(CHUNK_SUFFIX);
            this.dataBuffer.limit(this.dataBuffer.position());
            int startPos = 100 - chunkPrefix.length;
            this.dataBuffer.position(startPos);
            this.dataBuffer.put(chunkPrefix);
            this.dataBuffer.position(startPos);
        }
        this.complete = true;
        return true;
    }

    private void writeHeaderData() {
        ByteArrayOutputStream headerDataOut = new ByteArrayOutputStream();
        if (this.hasData()) {
            this.headers.put("Transfer-Encoding", new HttpHeader("Transfer-Encoding", "chunked"));
        } else {
            this.headers.put("Content-Length", new HttpHeader("Content-Length", "0"));
        }
        headerDataOut.writeBytes((this.version + " " + this.statusCode.getCode() + " " + this.statusCode.getMessage() + "\r\n").getBytes(StandardCharsets.UTF_8));
        for (HttpHeader header : this.headers.values()) {
            headerDataOut.writeBytes((header.getKey() + ": " + header.getValue() + "\r\n").getBytes(StandardCharsets.UTF_8));
        }
        headerDataOut.writeBytes("\r\n".getBytes(StandardCharsets.UTF_8));
        this.headerData = ByteBuffer.allocate(headerDataOut.size()).put(headerDataOut.toByteArray()).flip();
    }

    public void addHeader(String key, String value) {
        HttpHeader existing = this.getHeader(key);
        HttpHeader header = existing != null ? new HttpHeader(existing.getKey(), existing.getValue() + ", " + value) : new HttpHeader(key, value);
        this.headers.put(key.toLowerCase(Locale.ROOT), header);
    }

    public void setData(ReadableByteChannel channel) {
        this.data = channel;
    }

    public void setData(InputStream dataStream) {
        this.data = Channels.newChannel(dataStream);
    }

    public void setData(String data) {
        this.setData(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void close() throws IOException {
        if (this.data != null) {
            this.data.close();
        }
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(HttpStatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, HttpHeader> getHeaders() {
        return this.headers;
    }

    public HttpHeader getHeader(String header) {
        return this.headers.get(header.toLowerCase(Locale.ROOT));
    }

    public boolean hasHeaderValue(String key, String value) {
        HttpHeader header = this.getHeader(key);
        if (header == null) {
            return false;
        }
        return header.contains(value);
    }
}

