/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private final String format;

    public LogFormatter() {
        this("[%1$tF %1$tT][%4$s] %5$s%6$s%n");
    }

    public LogFormatter(String format) {
        this.format = format;
    }

    @Override
    public String format(LogRecord record) {
        Object source;
        ZonedDateTime zdt = ZonedDateTime.ofInstant(record.getInstant(), ZoneId.systemDefault());
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                source = (String)source + " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        return String.format(this.format, zdt, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
    }
}

