/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.jetbrains.annotations.Nullable;

public class ResourcePool<T> {
    private final Map<Key, T> pool = new HashMap<Key, T>();
    private final Map<Key, ResourcePath<T>> paths = new HashMap<Key, ResourcePath<T>>();

    public void put(Key path, T value) {
        this.put(new ResourcePath(path), value);
    }

    public synchronized void put(ResourcePath<T> path, T value) {
        this.pool.put(path, value);
        this.paths.put(path, path);
        path.setResource(value);
    }

    public void putIfAbsent(Key path, T value) {
        this.putIfAbsent(new ResourcePath(path), value);
    }

    public synchronized void putIfAbsent(ResourcePath<T> path, T value) {
        if (this.pool.putIfAbsent(path, value) == null) {
            this.paths.put(path, path);
            path.setResource(value);
        }
    }

    public Collection<ResourcePath<T>> paths() {
        return this.paths.values();
    }

    public Collection<T> values() {
        return this.pool.values();
    }

    public boolean contains(Key path) {
        return this.paths.containsKey(path);
    }

    @Nullable
    public T get(ResourcePath<T> path) {
        return this.pool.get(path);
    }

    @Nullable
    public T get(Key path) {
        ResourcePath<Object> rp = this.paths.get(path);
        return (T)(rp == null ? null : rp.getResource(this::get));
    }

    public synchronized void remove(Key path) {
        ResourcePath<T> removed = this.paths.remove(path);
        if (removed != null) {
            this.pool.remove(removed);
        }
    }

    @Nullable
    public ResourcePath<T> getPath(Key path) {
        return this.paths.get(path);
    }

    public void load(ResourcePath<T> path, Loader<T> loader) {
        try {
            if (this.contains(path)) {
                return;
            }
            T resource = loader.load(path);
            if (resource == null) {
                return;
            }
            this.put(path, resource);
        }
        catch (Exception ex) {
            Logger.global.logDebug("Failed to load resource '" + String.valueOf(path) + "': " + String.valueOf(ex));
        }
    }

    public void load(ResourcePath<T> path, Loader<T> loader, BinaryOperator<T> mergeFunction) {
        try {
            Object resource = loader.load(path);
            if (resource == null) {
                return;
            }
            T previous = this.get(path);
            if (previous != null) {
                resource = mergeFunction.apply(previous, resource);
            }
            this.put(path, resource);
        }
        catch (Exception ex) {
            Logger.global.logDebug("Failed to parse resource '" + String.valueOf(path) + "': " + String.valueOf(ex));
        }
    }

    public static interface Loader<T> {
        public T load(ResourcePath<T> var1) throws IOException;
    }
}

