/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas;

import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.ResourcePool;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.atlas.Source;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class SingleSource
extends Source {
    private ResourcePath<Texture> resource;
    @Nullable
    private ResourcePath<Texture> sprite;

    public SingleSource(ResourcePath<Texture> resource) {
        this.resource = resource;
    }

    @Override
    public void load(Path root, ResourcePool<Texture> textures, Predicate<Key> textureFilter) throws IOException {
        if (this.resource == null) {
            return;
        }
        ResourcePath<Texture> sprite = this.getSprite();
        if (textures.contains(sprite)) {
            return;
        }
        if (!textureFilter.test(sprite)) {
            return;
        }
        Path file = this.getFile(root, this.resource);
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        Texture texture = this.loadTexture(sprite, file);
        if (texture != null) {
            textures.put(sprite, texture);
        }
    }

    public ResourcePath<Texture> getSprite() {
        return this.sprite == null ? this.resource : this.sprite;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SingleSource that = (SingleSource)object;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.sprite, that.sprite);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.resource);
        result = 31 * result + Objects.hashCode(this.sprite);
        return result;
    }

    public ResourcePath<Texture> getResource() {
        return this.resource;
    }

    public SingleSource(ResourcePath<Texture> resource, @Nullable ResourcePath<Texture> sprite) {
        this.resource = resource;
        this.sprite = sprite;
    }

    private SingleSource() {
    }
}

