/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class InstancePool<T> {
    private final Supplier<T> creator;
    private final Function<T, T> recycler;
    private final ConcurrentLinkedQueue<T> pool = new ConcurrentLinkedQueue();
    @Nullable
    private final Duration autoClearTime;
    @Nullable
    private TimerTask autoClearTask = null;

    public InstancePool(Supplier<T> creator) {
        this.creator = creator;
        this.recycler = t2 -> t2;
        this.autoClearTime = null;
    }

    public InstancePool(Supplier<T> creator, Function<T, T> recycler) {
        this.creator = creator;
        this.recycler = recycler;
        this.autoClearTime = null;
    }

    public InstancePool(Supplier<T> creator, Function<T, T> recycler, @Nullable Duration autoClearTime) {
        this.creator = creator;
        this.recycler = recycler;
        this.autoClearTime = autoClearTime;
        this.updateAutoClear();
    }

    private synchronized void updateAutoClear() {
        if (this.autoClearTask != null) {
            this.autoClearTask.cancel();
        }
        if (this.autoClearTime != null) {
            this.autoClearTask = new TimerTask(){

                @Override
                public void run() {
                    InstancePool.this.clear();
                }
            };
            AutoClearTimer.INSTANCE.schedule(this.autoClearTask, this.autoClearTime.toMillis());
        }
    }

    public T claimInstance() {
        T instance = this.pool.poll();
        if (instance == null) {
            instance = this.creator.get();
        }
        this.updateAutoClear();
        return instance;
    }

    public void recycleInstance(T instance) {
        if ((instance = this.recycler.apply(instance)) != null) {
            this.pool.offer(instance);
        }
        this.updateAutoClear();
    }

    public void clear() {
        this.pool.clear();
    }

    private static final class AutoClearTimer {
        private static final Timer INSTANCE = new Timer("BlueMap-InstancePool-RecycleTimer", true);

        private AutoClearTimer() {
        }
    }
}

