/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca;

import com.flowpowered.math.vector.Vector2f;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.BlockEntity;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.Entity;
import de.bluecolored.bluemap.core.world.mca.blockentity.SignBlockEntity;
import de.bluecolored.bluemap.core.world.mca.data.BlockEntityTypeResolver;
import de.bluecolored.bluemap.core.world.mca.data.BlockStateDeserializer;
import de.bluecolored.bluemap.core.world.mca.data.EntityTypeResolver;
import de.bluecolored.bluemap.core.world.mca.data.KeyDeserializer;
import de.bluecolored.bluemap.core.world.mca.data.SignBlockEntityTypeResolver;
import de.bluecolored.bluemap.core.world.mca.data.UUIDDeserializer;
import de.bluecolored.bluemap.core.world.mca.data.Vector2fDeserializer;
import de.bluecolored.bluemap.core.world.mca.data.Vector2iDeserializer;
import de.bluecolored.bluemap.core.world.mca.data.Vector3dDeserializer;
import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.NamingStrategy;
import de.bluecolored.bluenbt.TypeToken;
import java.util.UUID;
import org.jetbrains.annotations.Contract;

public class MCAUtil {
    public static final BlueNBT BLUENBT = MCAUtil.addCommonNbtSettings(new BlueNBT());

    @Contract(value="_ -> param1", mutates="param1")
    public static BlueNBT addCommonNbtSettings(BlueNBT nbt) {
        nbt.setNamingStrategy(NamingStrategy.lowerCaseWithDelimiter("_"));
        nbt.register(TypeToken.of(BlockState.class), new BlockStateDeserializer());
        nbt.register(TypeToken.of(Key.class), new KeyDeserializer());
        nbt.register(TypeToken.of(UUID.class), new UUIDDeserializer());
        nbt.register(TypeToken.of(Vector3d.class), new Vector3dDeserializer());
        nbt.register(TypeToken.of(Vector2i.class), new Vector2iDeserializer());
        nbt.register(TypeToken.of(Vector2f.class), new Vector2fDeserializer());
        nbt.register(TypeToken.of(BlockEntity.class), new BlockEntityTypeResolver());
        nbt.register(TypeToken.of(SignBlockEntity.class), new SignBlockEntityTypeResolver());
        nbt.register(TypeToken.of(Entity.class), new EntityTypeResolver());
        return nbt;
    }

    public static long getValueFromLongStream(long[] data, int valueIndex, int bitsPerValue) {
        int bitIndex = valueIndex * bitsPerValue;
        int firstLong = bitIndex >> 6;
        int bitOffset = bitIndex & 0x3F;
        if (firstLong >= data.length) {
            return 0L;
        }
        long value = data[firstLong] >>> bitOffset;
        if (bitOffset > 0 && firstLong + 1 < data.length) {
            long value2 = data[firstLong + 1];
            value |= (value2 <<= -bitOffset);
        }
        return value & -1L >>> -bitsPerValue;
    }

    public static int getByteHalf(int value, boolean largeHalf) {
        if (largeHalf) {
            return value >> 4 & 0xF;
        }
        return value & 0xF;
    }

    public static int ceilLog2(int n) {
        return 32 - Integer.numberOfLeadingZeros(n - 1);
    }
}

