/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.chunk;

import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class LegacyBiomes {
    @Nullable
    private static final Key[] BIOME_KEYS = new Key[170];
    @Nullable
    private final Biome[] biomes = new Biome[BIOME_KEYS.length];

    public LegacyBiomes(DataPack dataPack) {
        for (int i = 0; i < this.biomes.length; ++i) {
            Key key = BIOME_KEYS[i];
            if (key == null) continue;
            this.biomes[i] = dataPack.getBiome(key);
        }
    }

    @Nullable
    public Biome forId(int legacyId) {
        if (legacyId < 0 || legacyId >= this.biomes.length) {
            return null;
        }
        return this.biomes[legacyId];
    }

    static {
        LegacyBiomes.BIOME_KEYS[0] = Key.minecraft("ocean");
        LegacyBiomes.BIOME_KEYS[1] = Key.minecraft("plains");
        LegacyBiomes.BIOME_KEYS[2] = Key.minecraft("desert");
        LegacyBiomes.BIOME_KEYS[3] = Key.minecraft("mountains");
        LegacyBiomes.BIOME_KEYS[4] = Key.minecraft("forest");
        LegacyBiomes.BIOME_KEYS[5] = Key.minecraft("taiga");
        LegacyBiomes.BIOME_KEYS[6] = Key.minecraft("swamp");
        LegacyBiomes.BIOME_KEYS[7] = Key.minecraft("river");
        LegacyBiomes.BIOME_KEYS[8] = Key.minecraft("nether");
        LegacyBiomes.BIOME_KEYS[9] = Key.minecraft("the_end");
        LegacyBiomes.BIOME_KEYS[10] = Key.minecraft("frozen_ocean");
        LegacyBiomes.BIOME_KEYS[11] = Key.minecraft("frozen_river");
        LegacyBiomes.BIOME_KEYS[12] = Key.minecraft("snowy_tundra");
        LegacyBiomes.BIOME_KEYS[13] = Key.minecraft("snowy_mountains");
        LegacyBiomes.BIOME_KEYS[14] = Key.minecraft("mushroom_fields");
        LegacyBiomes.BIOME_KEYS[15] = Key.minecraft("mushroom_field_shore");
        LegacyBiomes.BIOME_KEYS[16] = Key.minecraft("beach");
        LegacyBiomes.BIOME_KEYS[17] = Key.minecraft("desert_hills");
        LegacyBiomes.BIOME_KEYS[18] = Key.minecraft("wooded_hills");
        LegacyBiomes.BIOME_KEYS[19] = Key.minecraft("taiga_hills");
        LegacyBiomes.BIOME_KEYS[20] = Key.minecraft("mountain_edge");
        LegacyBiomes.BIOME_KEYS[21] = Key.minecraft("jungle");
        LegacyBiomes.BIOME_KEYS[22] = Key.minecraft("jungle_hills");
        LegacyBiomes.BIOME_KEYS[23] = Key.minecraft("jungle_edge");
        LegacyBiomes.BIOME_KEYS[24] = Key.minecraft("deep_ocean");
        LegacyBiomes.BIOME_KEYS[25] = Key.minecraft("stone_shore");
        LegacyBiomes.BIOME_KEYS[26] = Key.minecraft("snowy_beach");
        LegacyBiomes.BIOME_KEYS[27] = Key.minecraft("birch_forest");
        LegacyBiomes.BIOME_KEYS[28] = Key.minecraft("birch_forest_hills");
        LegacyBiomes.BIOME_KEYS[29] = Key.minecraft("dark_forest");
        LegacyBiomes.BIOME_KEYS[30] = Key.minecraft("snowy_taiga");
        LegacyBiomes.BIOME_KEYS[31] = Key.minecraft("snowy_taiga_hills");
        LegacyBiomes.BIOME_KEYS[32] = Key.minecraft("giant_tree_taiga");
        LegacyBiomes.BIOME_KEYS[33] = Key.minecraft("giant_tree_taiga_hills");
        LegacyBiomes.BIOME_KEYS[34] = Key.minecraft("wooded_mountains");
        LegacyBiomes.BIOME_KEYS[35] = Key.minecraft("savanna");
        LegacyBiomes.BIOME_KEYS[36] = Key.minecraft("savanna_plateau");
        LegacyBiomes.BIOME_KEYS[37] = Key.minecraft("badlands");
        LegacyBiomes.BIOME_KEYS[38] = Key.minecraft("wooded_badlands_plateau");
        LegacyBiomes.BIOME_KEYS[39] = Key.minecraft("badlands_plateau");
        LegacyBiomes.BIOME_KEYS[40] = Key.minecraft("small_end_islands");
        LegacyBiomes.BIOME_KEYS[41] = Key.minecraft("end_midlands");
        LegacyBiomes.BIOME_KEYS[42] = Key.minecraft("end_highlands");
        LegacyBiomes.BIOME_KEYS[43] = Key.minecraft("end_barrens");
        LegacyBiomes.BIOME_KEYS[44] = Key.minecraft("warm_ocean");
        LegacyBiomes.BIOME_KEYS[45] = Key.minecraft("lukewarm_ocean");
        LegacyBiomes.BIOME_KEYS[46] = Key.minecraft("cold_ocean");
        LegacyBiomes.BIOME_KEYS[47] = Key.minecraft("deep_warm_ocean");
        LegacyBiomes.BIOME_KEYS[48] = Key.minecraft("deep_lukewarm_ocean");
        LegacyBiomes.BIOME_KEYS[49] = Key.minecraft("deep_cold_ocean");
        LegacyBiomes.BIOME_KEYS[50] = Key.minecraft("deep_frozen_ocean");
        LegacyBiomes.BIOME_KEYS[127] = Key.minecraft("the_void");
        LegacyBiomes.BIOME_KEYS[129] = Key.minecraft("sunflower_plains");
        LegacyBiomes.BIOME_KEYS[130] = Key.minecraft("desert_lakes");
        LegacyBiomes.BIOME_KEYS[131] = Key.minecraft("gravelly_mountains");
        LegacyBiomes.BIOME_KEYS[132] = Key.minecraft("flower_forest");
        LegacyBiomes.BIOME_KEYS[133] = Key.minecraft("taiga_mountains");
        LegacyBiomes.BIOME_KEYS[134] = Key.minecraft("swamp_hills");
        LegacyBiomes.BIOME_KEYS[140] = Key.minecraft("ice_spikes");
        LegacyBiomes.BIOME_KEYS[149] = Key.minecraft("modified_jungle");
        LegacyBiomes.BIOME_KEYS[151] = Key.minecraft("modified_jungle_edge");
        LegacyBiomes.BIOME_KEYS[155] = Key.minecraft("tall_birch_forest");
        LegacyBiomes.BIOME_KEYS[156] = Key.minecraft("tall_birch_hills");
        LegacyBiomes.BIOME_KEYS[157] = Key.minecraft("dark_forest_hills");
        LegacyBiomes.BIOME_KEYS[158] = Key.minecraft("snowy_taiga_mountains");
        LegacyBiomes.BIOME_KEYS[160] = Key.minecraft("giant_spruce_taiga");
        LegacyBiomes.BIOME_KEYS[161] = Key.minecraft("giant_spruce_taiga_hills");
        LegacyBiomes.BIOME_KEYS[162] = Key.minecraft("modified_gravelly_mountains");
        LegacyBiomes.BIOME_KEYS[163] = Key.minecraft("shattered_savanna");
        LegacyBiomes.BIOME_KEYS[164] = Key.minecraft("shattered_savanna_plateau");
        LegacyBiomes.BIOME_KEYS[165] = Key.minecraft("eroded_badlands");
        LegacyBiomes.BIOME_KEYS[166] = Key.minecraft("modified_wooded_badlands_plateau");
        LegacyBiomes.BIOME_KEYS[167] = Key.minecraft("modified_badlands_plateau");
        LegacyBiomes.BIOME_KEYS[168] = Key.minecraft("bamboo_jungle");
        LegacyBiomes.BIOME_KEYS[169] = Key.minecraft("bamboo_jungle_hills");
    }
}

