/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.NBTWriter;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeAdapter;
import de.bluecolored.bluenbt.TypeAdapterFactory;
import de.bluecolored.bluenbt.TypeDeserializer;
import de.bluecolored.bluenbt.TypeSerializer;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;

public class ArrayAdapterFactory
implements TypeAdapterFactory {
    public static final ArrayAdapterFactory INSTANCE = new ArrayAdapterFactory();

    public <T> Optional<TypeAdapter<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        if (!typeToken.isArray()) {
            return Optional.empty();
        }
        TypeToken<?> componentType = TypeToken.of(typeToken.getComponentType());
        TypeSerializer<?> componentTypeSerializer = blueNBT.getTypeSerializer(componentType);
        TypeDeserializer<?> componentTypeDeserializer = blueNBT.getTypeDeserializer(componentType);
        ArrayAdapter result = new ArrayAdapter(componentType.getRawType(), componentTypeSerializer, componentTypeDeserializer);
        return Optional.of(result);
    }

    static class ArrayAdapter<E>
    implements TypeAdapter<Object> {
        private final Class<E> type;
        private final TypeSerializer<E> typeSerializer;
        private final TypeDeserializer<E> typeDeserializer;

        @Override
        public Object read(NBTReader reader) throws IOException {
            TagType tag = reader.peek();
            if (tag == TagType.BYTE_ARRAY && this.type.equals(Byte.TYPE)) {
                return reader.nextByteArray();
            }
            if (tag == TagType.INT_ARRAY && this.type.equals(Integer.TYPE)) {
                return reader.nextIntArray();
            }
            if (tag == TagType.LONG_ARRAY && this.type.equals(Long.TYPE)) {
                return reader.nextLongArray();
            }
            if (tag == TagType.BYTE_ARRAY || tag == TagType.INT_ARRAY || tag == TagType.LONG_ARRAY) {
                return reader.nextArray(length -> Array.newInstance(this.type, length));
            }
            int length2 = reader.beginList();
            Object array = Array.newInstance(this.type, length2);
            for (int i = 0; i < length2; ++i) {
                E instance = this.typeDeserializer.read(reader);
                Array.set(array, i, instance);
            }
            reader.endList();
            return array;
        }

        @Override
        public void write(Object value, NBTWriter writer) throws IOException {
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, int[].class, long[].class}, (Object)object2, n)) {
                case 0: {
                    byte[] bytes = (byte[])object2;
                    writer.value(bytes);
                    break;
                }
                case 1: {
                    int[] ints = (int[])object2;
                    writer.value(ints);
                    break;
                }
                case 2: {
                    long[] longs = (long[])object2;
                    writer.value(longs);
                    break;
                }
                default: {
                    int length = Array.getLength(value);
                    if (length == 0) {
                        writer.beginList(length, this.typeSerializer.type());
                        writer.endList();
                        break;
                    }
                    writer.beginList(length);
                    for (int i = 0; i < length; ++i) {
                        this.typeSerializer.write(Objects.requireNonNull(Array.get(value, i), "'null' values are not supported in a list."), writer);
                    }
                    writer.endList();
                }
            }
        }

        @Override
        public TagType type() {
            if (this.type.equals(Byte.TYPE)) {
                return TagType.BYTE_ARRAY;
            }
            if (this.type.equals(Integer.TYPE)) {
                return TagType.INT_ARRAY;
            }
            if (this.type.equals(Long.TYPE)) {
                return TagType.LONG_ARRAY;
            }
            return TagType.LIST;
        }

        public ArrayAdapter(Class<E> type, TypeSerializer<E> typeSerializer, TypeDeserializer<E> typeDeserializer) {
            this.type = type;
            this.typeSerializer = typeSerializer;
            this.typeDeserializer = typeDeserializer;
        }
    }
}

