/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.InstanceCreator;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.NBTWriter;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeAdapter;
import de.bluecolored.bluenbt.TypeAdapterFactory;
import de.bluecolored.bluenbt.TypeDeserializer;
import de.bluecolored.bluenbt.TypeSerializer;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class CollectionAdapterFactory
implements TypeAdapterFactory {
    public static final CollectionAdapterFactory INSTANCE = new CollectionAdapterFactory();

    public <T> Optional<TypeAdapter<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        if (!typeToken.is(Collection.class)) {
            return Optional.empty();
        }
        Type elementType = this.getCollectionElementType(typeToken);
        TypeToken<?> elementTypeToken = TypeToken.of(elementType);
        TypeSerializer<?> elementTypeSerializer = blueNBT.getTypeSerializer(elementTypeToken);
        TypeDeserializer<?> elementTypeDeserializer = blueNBT.getTypeDeserializer(elementTypeToken);
        InstanceCreator<T> constructor = blueNBT.getInstanceCreator(typeToken);
        CollectionAdapter result = new CollectionAdapter(elementTypeSerializer, elementTypeDeserializer, constructor);
        return Optional.of(result);
    }

    private Type getCollectionElementType(TypeToken<?> type) {
        Type type2 = type.getSupertype(Collection.class);
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ParameterizedType.class, WildcardType.class}, (Object)type3, n)) {
            case 0 -> {
                ParameterizedType parameterizedType = (ParameterizedType)type3;
                yield parameterizedType.getActualTypeArguments()[0];
            }
            case 1 -> {
                WildcardType wildcardType = (WildcardType)type3;
                yield wildcardType.getUpperBounds()[0];
            }
            default -> Object.class;
        };
    }

    static class CollectionAdapter<E>
    implements TypeAdapter<Collection<E>> {
        private final TypeSerializer<E> typeSerializer;
        private final TypeDeserializer<E> typeDeserializer;
        private final InstanceCreator<? extends Collection<E>> constructor;

        @Override
        public Collection<E> read(NBTReader reader) throws IOException {
            Collection<E> collection = this.constructor.create();
            reader.beginList();
            while (reader.hasNext()) {
                E instance = this.typeDeserializer.read(reader);
                collection.add(instance);
            }
            reader.endList();
            return collection;
        }

        @Override
        public void write(Collection<E> value, NBTWriter writer) throws IOException {
            int size = value.size();
            if (size == 0) {
                writer.beginList(size, this.typeSerializer.type());
                writer.endList();
            } else {
                writer.beginList(size);
                for (E element : value) {
                    this.typeSerializer.write(Objects.requireNonNull(element, "'null' values are not supported in a list."), writer);
                }
                writer.endList();
            }
        }

        @Override
        public TagType type() {
            return TagType.LIST;
        }

        public CollectionAdapter(TypeSerializer<E> typeSerializer, TypeDeserializer<E> typeDeserializer, InstanceCreator<? extends Collection<E>> constructor) {
            this.typeSerializer = typeSerializer;
            this.typeDeserializer = typeDeserializer;
            this.constructor = constructor;
        }
    }
}

