/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.NBTWriter;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeAdapter;
import de.bluecolored.bluenbt.TypeAdapterFactory;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.util.Optional;

public class EnumAdapterFactory
implements TypeAdapterFactory {
    public static final EnumAdapterFactory INSTANCE = new EnumAdapterFactory();

    @Override
    public <T> Optional<? extends TypeAdapter<T>> create(TypeToken<T> type, BlueNBT blueNBT) {
        Class<T> rawType = type.getRawType();
        if (rawType.isEnum()) {
            return Optional.of(new EnumAdapter<T>(rawType));
        }
        return Optional.empty();
    }

    static class EnumAdapter<E extends Enum<E>>
    implements TypeAdapter<E> {
        private final Class<E> enumType;
        private final E[] universe;

        public EnumAdapter(Class<E> enumType) {
            this.enumType = enumType;
            this.universe = (Enum[])enumType.getEnumConstants();
        }

        @Override
        public void write(E value, NBTWriter writer) throws IOException {
            writer.value(((Enum)value).name());
        }

        @Override
        public TagType type() {
            return TagType.STRING;
        }

        @Override
        public E read(NBTReader reader) throws IOException {
            try {
                return (E)(switch (reader.peek()) {
                    case TagType.STRING -> (Enum)Enum.valueOf(this.enumType, reader.nextString());
                    case TagType.LONG -> (Enum)this.universe[(int)reader.nextLong()];
                    case TagType.INT -> (Enum)this.universe[reader.nextInt()];
                    case TagType.SHORT -> (Enum)this.universe[reader.nextShort()];
                    case TagType.BYTE -> (Enum)this.universe[reader.nextByte()];
                    default -> throw new IOException("Can't convert type %s into enum-type %s at %s".formatted(new Object[]{reader.peek(), this.enumType, reader.path()}));
                });
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                throw new IOException("Invalid value for enum type %s at %s".formatted(this.enumType, reader.path()));
            }
        }
    }
}

