/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt.adapter;

import de.bluecolored.bluenbt.BlueNBT;
import de.bluecolored.bluenbt.InstanceCreator;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.NBTWriter;
import de.bluecolored.bluenbt.TypeAdapter;
import de.bluecolored.bluenbt.TypeAdapterFactory;
import de.bluecolored.bluenbt.TypeDeserializer;
import de.bluecolored.bluenbt.TypeSerializer;
import de.bluecolored.bluenbt.TypeToken;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;

public class MapAdapterFactory
implements TypeAdapterFactory {
    public static final MapAdapterFactory INSTANCE = new MapAdapterFactory();

    public <T> Optional<TypeAdapter<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        Function<Object, Object> fromStringFunction;
        Function<Object, Object> toStringFunction;
        Type[] keyAndValueTypes = this.getMapKeyAndValueTypes(typeToken);
        Class<?> keyType = TypeToken.of(keyAndValueTypes[0]).getRawType();
        if (String.class.equals(keyType)) {
            toStringFunction = Function.identity();
            fromStringFunction = Function.identity();
        } else if (Enum.class.isAssignableFrom(keyType)) {
            toStringFunction = Enum::name;
            fromStringFunction = name -> Enum.valueOf((Class)keyAndValueTypes[0], name);
        } else {
            return Optional.empty();
        }
        TypeToken<?> valueType = TypeToken.of(keyAndValueTypes[1]);
        TypeSerializer<?> elementTypeSerializer = blueNBT.getTypeSerializer(valueType);
        TypeDeserializer<?> elementTypeDeserializer = blueNBT.getTypeDeserializer(valueType);
        InstanceCreator<T> constructor = blueNBT.getInstanceCreator(typeToken);
        MapAdapter result = new MapAdapter(toStringFunction, fromStringFunction, elementTypeSerializer, elementTypeDeserializer, constructor);
        return Optional.of(result);
    }

    private Type[] getMapKeyAndValueTypes(TypeToken<?> type) {
        Type[] typeArray;
        if (type.is(Properties.class)) {
            return new Type[]{String.class, String.class};
        }
        Type type2 = type.getSupertype(Map.class);
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            typeArray = parameterizedType.getActualTypeArguments();
        } else {
            Type[] typeArray2 = new Type[2];
            typeArray2[0] = Object.class;
            typeArray = typeArray2;
            typeArray2[1] = Object.class;
        }
        return typeArray;
    }

    static class MapAdapter<K, E>
    implements TypeAdapter<Map<K, E>> {
        private final Function<K, String> toStringFunction;
        private final Function<String, K> fromStringFunction;
        private final TypeSerializer<E> typeSerializer;
        private final TypeDeserializer<E> typeDeserializer;
        private final InstanceCreator<? extends Map<K, E>> constructor;

        @Override
        public Map<K, E> read(NBTReader reader) throws IOException {
            Map<K, E> map = this.constructor.create();
            reader.beginCompound();
            while (reader.hasNext()) {
                String keyString = reader.name();
                K key = this.fromStringFunction.apply(keyString);
                E instance = this.typeDeserializer.read(reader);
                map.put(key, instance);
            }
            reader.endCompound();
            return map;
        }

        @Override
        public void write(Map<K, E> value, NBTWriter writer) throws IOException {
            writer.beginCompound();
            for (Map.Entry<K, E> entry : value.entrySet()) {
                String keyString = this.toStringFunction.apply(entry.getKey());
                writer.name(keyString);
                this.typeSerializer.write(entry.getValue(), writer);
            }
            writer.endCompound();
        }

        public MapAdapter(Function<K, String> toStringFunction, Function<String, K> fromStringFunction, TypeSerializer<E> typeSerializer, TypeDeserializer<E> typeDeserializer, InstanceCreator<? extends Map<K, E>> constructor) {
            this.toStringFunction = toStringFunction;
            this.fromStringFunction = fromStringFunction;
            this.typeSerializer = typeSerializer;
            this.typeDeserializer = typeDeserializer;
            this.constructor = constructor;
        }
    }
}

