/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands;

import de.bluecolored.bluecommands.ArgumentCommand;
import de.bluecolored.bluecommands.Command;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.ParseResult;
import de.bluecolored.bluecommands.ParseSegment;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParseData<C, T> {
    private final C context;
    private final InputReader input;
    private final ParseResult<C, T> result;
    private final LinkedList<ParseSegment<C, T>> segments;

    public ParseData(C context, InputReader input, Command<C, T> initialSegment) {
        this.context = context;
        this.input = input;
        this.result = new ParseResult(context, input.getInput());
        this.segments = new LinkedList();
        this.pushSegment(initialSegment);
    }

    public C getContext() {
        return this.context;
    }

    public InputReader getInput() {
        return this.input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getArguments() {
        LinkedList<ParseSegment<C, T>> linkedList = this.segments;
        synchronized (linkedList) {
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            for (ParseSegment parseSegment : this.segments) {
                if (!(parseSegment.getCommand() instanceof ArgumentCommand)) continue;
                ArgumentCommand argumentCommand = (ArgumentCommand)parseSegment.getCommand();
                arguments.put(argumentCommand.getArgumentId(), parseSegment.getValue());
            }
            return Collections.unmodifiableMap(arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParseSegment<C, T>> getCommandStack() {
        LinkedList<ParseSegment<C, T>> linkedList = this.segments;
        synchronized (linkedList) {
            return List.copyOf(this.segments);
        }
    }

    public ParseResult<C, T> getResult() {
        return this.result;
    }

    public ParseSegment<C, T> getCurrentSegment() {
        return this.segments.getLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushSegment(Command<C, T> command) {
        LinkedList<ParseSegment<C, T>> linkedList = this.segments;
        synchronized (linkedList) {
            this.segments.addLast(new ParseSegment<C, T>(command, this.input.getPosition()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popSegment() {
        LinkedList<ParseSegment<C, T>> linkedList = this.segments;
        synchronized (linkedList) {
            this.input.setPosition(this.segments.removeLast().getPosition());
        }
    }
}

