/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.storage;

import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.storage.file.FileStorage;
import de.bluecolored.shadow.configurate.objectmapping.ConfigSerializable;
import java.nio.file.Path;

@ConfigSerializable
public class FileConfig
extends StorageConfig {
    private Path root = Path.of("bluemap", "web", "maps");
    private String compression = Compression.GZIP.getKey().getFormatted();
    private boolean atomic = true;

    public Compression getCompression() throws ConfigurationException {
        return FileConfig.parseKey(Compression.REGISTRY, this.compression, "compression");
    }

    @Override
    public FileStorage createStorage() throws ConfigurationException {
        return new FileStorage(this.root, this.getCompression(), this.atomic);
    }

    public Path getRoot() {
        return this.root;
    }

    public boolean isAtomic() {
        return this.atomic;
    }
}

