/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.lowres;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.util.math.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.imageio.ImageIO;

public class LowresTile {
    public static final int HEIGHT_UNDEFINED = Integer.MIN_VALUE;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final BufferedImage texture;
    private final Vector2i size;

    public LowresTile(Vector2i tileSize) {
        this.size = tileSize.add(1, 1);
        this.texture = new BufferedImage(this.size.getX(), this.size.getY() * 2, 2);
    }

    public LowresTile(Vector2i tileSize, InputStream in) throws IOException {
        this.size = tileSize.add(1, 1);
        this.texture = ImageIO.read(in);
        if (this.texture == null) {
            throw new IOException("No registered ImageReader is able to read the image-stream");
        }
        if (this.texture.getWidth() != this.size.getX() || this.texture.getHeight() != this.size.getY() * 2) {
            throw new IOException("Size of tile does not match");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int x, int z, Color color, int height, int blockLight) {
        this.lock.readLock().lock();
        try {
            this.texture.setRGB(x, z, color.straight().getInt());
            this.texture.setRGB(x, this.size.getY() + z, height & 0xFFFF | blockLight << 16 & 0xFF0000 | 0xFF000000);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Color getColor(int x, int z, Color target) {
        return target.set(this.texture.getRGB(x, z));
    }

    public int getHeight(int x, int z) {
        int height = this.texture.getRGB(x, this.size.getY() + z) & 0xFFFF;
        if (height > 32768) {
            return height | 0xFFFF0000;
        }
        return height;
    }

    public int getBlockLight(int x, int z) {
        return (this.texture.getRGB(x, this.size.getY() + z) & 0xFF0000) >> 16;
    }

    public void save(OutputStream out) throws IOException {
        this.lock.writeLock().lock();
        try {
            ImageIO.write((RenderedImage)this.texture, "png", out);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

