/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.mask;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.map.mask.Mask;
import de.bluecolored.bluemap.core.util.Tristate;

public class BoxMask
implements Mask {
    private final Vector3i min;
    private final Vector3i max;

    @Override
    public boolean test(int x, int y, int z) {
        return this.testXZ(x, z) && y >= this.min.getY() && y <= this.max.getY();
    }

    public boolean testXZ(int x, int z) {
        return x >= this.min.getX() && x <= this.max.getX() && z >= this.min.getZ() && z <= this.max.getZ();
    }

    @Override
    public Tristate test(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (minX >= this.min.getX() && maxX <= this.max.getX() && minZ >= this.min.getZ() && maxZ <= this.max.getZ() && minY >= this.min.getY() && maxY <= this.max.getY()) {
            return Tristate.TRUE;
        }
        if (maxX < this.min.getX() || minX > this.max.getX() || maxZ < this.min.getZ() || minZ > this.max.getZ() || maxY < this.min.getY() || minY > this.max.getY()) {
            return Tristate.FALSE;
        }
        return Tristate.UNDEFINED;
    }

    @Override
    public boolean isEdge(int minX, int minZ, int maxX, int maxZ) {
        return this.test(minX, this.min.getY(), minZ, maxX, this.max.getY(), maxZ) == Tristate.UNDEFINED;
    }

    public BoxMask(Vector3i min2, Vector3i max) {
        this.min = min2;
        this.max = max;
    }
}

