/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.renderstate;

import de.bluecolored.bluemap.core.map.renderstate.CellStorage;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.util.Grid;

public class MapTileState
extends CellStorage<TileInfoRegion> {
    static final int SHIFT = 5;
    public static final Grid GRID = new Grid(32);
    private int lastRenderTime = -1;

    public MapTileState(GridStorage storage) {
        super(storage, TileInfoRegion.class);
    }

    public TileInfoRegion.TileInfo get(int x, int z) {
        return ((TileInfoRegion)this.cell(x >> 5, z >> 5)).get(x, z);
    }

    public synchronized TileInfoRegion.TileInfo set(int x, int z, TileInfoRegion.TileInfo info) {
        TileInfoRegion.TileInfo old = ((TileInfoRegion)this.cell(x >> 5, z >> 5)).set(x, z, info);
        if (info.getRenderTime() > this.lastRenderTime) {
            this.lastRenderTime = info.getRenderTime();
        }
        return old;
    }

    @Override
    protected synchronized TileInfoRegion createNewCell() {
        return TileInfoRegion.create();
    }

    public int getLastRenderTime() {
        return this.lastRenderTime;
    }
}

