/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.model;

import com.flowpowered.math.TrigMath;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.resources.adapter.PostDeserialize;
import de.bluecolored.bluemap.core.util.math.Axis;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;

public class Rotation {
    private static final Vector3f DEFAULT_ORIGIN = new Vector3f(8.0f, 8.0f, 8.0f);
    private static final double FIT_TO_BLOCK_SCALE_MULTIPLIER = 2.0 - Math.sqrt(2.0);
    public static final Rotation ZERO = new Rotation();
    private Vector3f origin = DEFAULT_ORIGIN;
    private Axis axis = Axis.Y;
    private float angle = 0.0f;
    private boolean rescale = false;
    private transient MatrixM4f matrix;

    public Rotation(Vector3f origin, Axis axis, float angle, boolean rescale) {
        this.origin = origin;
        this.axis = axis;
        this.angle = angle;
        this.rescale = rescale;
        this.init();
    }

    @PostDeserialize
    private void init() {
        Vector3i axisAngle = this.axis.toVector();
        this.matrix = new MatrixM4f();
        if (this.angle != 0.0f) {
            this.matrix.translate(-this.origin.getX(), -this.origin.getY(), -this.origin.getZ());
            this.matrix.rotate(this.angle, axisAngle.getX(), axisAngle.getY(), axisAngle.getZ());
            if (this.rescale) {
                float scale = (float)((double)Math.abs(TrigMath.sin((double)((double)this.angle * (Math.PI / 180)))) * FIT_TO_BLOCK_SCALE_MULTIPLIER);
                this.matrix.scale((float)(1 - axisAngle.getX()) * scale + 1.0f, (float)(1 - axisAngle.getY()) * scale + 1.0f, (float)(1 - axisAngle.getZ()) * scale + 1.0f);
            }
            this.matrix.translate(this.origin.getX(), this.origin.getY(), this.origin.getZ());
        }
    }

    private Rotation() {
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isRescale() {
        return this.rescale;
    }

    public MatrixM4f getMatrix() {
        return this.matrix;
    }

    static {
        ZERO.init();
    }
}

