/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import de.bluecolored.bluemap.core.util.FileTreeWalker;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class FileTreeIterator
implements Iterator<FileTreeWalker.Event>,
Closeable {
    private final FileTreeWalker walker;
    private FileTreeWalker.Event next;

    FileTreeIterator(Path start, int maxDepth, FileVisitOption ... options) throws IOException {
        this.walker = new FileTreeWalker(List.of(options), maxDepth);
        this.next = this.walker.walk(start);
        assert (this.next.type() == FileTreeWalker.EventType.ENTRY || this.next.type() == FileTreeWalker.EventType.START_DIRECTORY);
        IOException ioe = this.next.ioeException();
        if (ioe != null) {
            throw ioe;
        }
    }

    private void fetchNextIfNeeded() {
        if (this.next == null) {
            FileTreeWalker.Event ev = this.walker.next();
            while (ev != null) {
                IOException ioe = ev.ioeException();
                if (ioe != null) {
                    if (ioe instanceof NoSuchFileException) {
                        ev = this.walker.next();
                        continue;
                    }
                    throw new UncheckedIOException(ioe);
                }
                if (ev.type() != FileTreeWalker.EventType.END_DIRECTORY) {
                    this.next = ev;
                    return;
                }
                ev = this.walker.next();
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.walker.isOpen()) {
            throw new IllegalStateException();
        }
        this.fetchNextIfNeeded();
        return this.next != null;
    }

    @Override
    public FileTreeWalker.Event next() {
        if (!this.walker.isOpen()) {
            throw new IllegalStateException();
        }
        this.fetchNextIfNeeded();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        FileTreeWalker.Event result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void close() {
        this.walker.close();
    }
}

