/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeEventForwarder {
    private final Collection<ServerEventListener> eventListeners = new ArrayList<ServerEventListener>(1);

    public synchronized void addEventListener(ServerEventListener listener) {
        this.eventListeners.add(listener);
    }

    public synchronized void removeAllListeners() {
        this.eventListeners.clear();
    }

    @SubscribeEvent
    public synchronized void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        UUID uuid = evt.getEntity().getUUID();
        for (ServerEventListener listener : this.eventListeners) {
            listener.onPlayerJoin(uuid);
        }
    }

    @SubscribeEvent
    public synchronized void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent evt) {
        UUID uuid = evt.getEntity().getUUID();
        for (ServerEventListener listener : this.eventListeners) {
            listener.onPlayerLeave(uuid);
        }
    }
}

