/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import com.mojang.brigadier.tree.RootCommandNode;
import de.bluecolored.bluecommands.brigadier.BrigadierBridge;
import de.bluecolored.bluemap.common.commands.BrigadierExecutionHandler;
import de.bluecolored.bluemap.common.commands.Commands;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.Server;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.forge.ForgeCommandSource;
import de.bluecolored.bluemap.forge.ForgeEventForwarder;
import de.bluecolored.bluemap.forge.ForgePlayer;
import de.bluecolored.bluemap.forge.ForgeWorld;
import de.bluecolored.bluemap.forge.Log4jLogger;
import de.bluecolored.shadow.caffeine.cache.Caffeine;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;

@Mod(value="bluemap")
public class ForgeMod
implements Server {
    private final Plugin pluginInstance;
    private MinecraftServer serverInstance = null;
    private final ForgeEventForwarder eventForwarder;
    private final LoadingCache<ServerLevel, ServerWorld> worlds;
    private int playerUpdateIndex = 0;
    private final Map<UUID, de.bluecolored.bluemap.common.serverinterface.Player> onlinePlayerMap;
    private final List<ForgePlayer> onlinePlayerList;

    public ForgeMod(FMLJavaModLoadingContext context) {
        Logger.global.clear();
        Logger.global.put(new Log4jLogger(LogManager.getLogger((String)"BlueMap")));
        this.onlinePlayerMap = new ConcurrentHashMap<UUID, de.bluecolored.bluemap.common.serverinterface.Player>();
        this.onlinePlayerList = Collections.synchronizedList(new ArrayList());
        this.pluginInstance = new Plugin("forge", this);
        this.eventForwarder = new ForgeEventForwarder();
        this.worlds = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).weakKeys().maximumSize(1000L).build(ForgeWorld::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.eventForwarder);
        context.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "SERVER_ONLY", (a, b) -> true));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.serverInstance = event.getServer();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        BrigadierBridge.createCommandNodes(Commands.create(this.pluginInstance), new BrigadierExecutionHandler(this.pluginInstance), forgeSource -> new ForgeCommandSource(this, (CommandSourceStack)forgeSource)).forEach(arg_0 -> ((RootCommandNode)event.getDispatcher().getRoot()).addChild(arg_0));
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        this.serverInstance.saveAllChunks(false, true, true);
        new Thread(() -> {
            Logger.global.logInfo("Loading...");
            try {
                this.pluginInstance.load();
                if (this.pluginInstance.isLoaded()) {
                    Logger.global.logInfo("Loaded!");
                }
            }
            catch (IOException e) {
                Logger.global.logError("Failed to load bluemap!", e);
                this.pluginInstance.unload();
            }
        }, "BlueMap-Plugin-Loading").start();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.pluginInstance.unload();
        Logger.global.logInfo("BlueMap unloaded!");
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent.Post evt) {
        this.updateSomePlayers();
    }

    @Override
    public String getMinecraftVersion() {
        return SharedConstants.getCurrentVersion().id();
    }

    @Override
    public void registerListener(ServerEventListener listener) {
        this.eventForwarder.addEventListener(listener);
    }

    @Override
    public void unregisterAllListeners() {
        this.eventForwarder.removeAllListeners();
    }

    @Override
    public Collection<ServerWorld> getLoadedServerWorlds() {
        ArrayList<ServerWorld> loadedWorlds = new ArrayList<ServerWorld>(3);
        for (ServerLevel serverWorld : this.serverInstance.getAllLevels()) {
            loadedWorlds.add(this.worlds.get(serverWorld));
        }
        return loadedWorlds;
    }

    @Override
    public Optional<ServerWorld> getServerWorld(Object world) {
        ResourceLocation resourceLocation;
        if (world instanceof String && (resourceLocation = ResourceLocation.tryParse((String)((String)world))) != null) {
            world = this.serverInstance.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)resourceLocation));
        }
        if (world instanceof ResourceKey) {
            try {
                world = this.serverInstance.getLevel((ResourceKey)world);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (world instanceof ServerLevel) {
            return Optional.of(this.getServerWorld((ServerLevel)world));
        }
        return Optional.empty();
    }

    public ServerWorld getServerWorld(ServerLevel world) {
        return this.worlds.get(Objects.requireNonNull(world));
    }

    @Override
    public Path getConfigFolder() {
        return Path.of("config", "bluemap");
    }

    @Override
    public Optional<Path> getModsFolder() {
        return Optional.of(Path.of("mods", new String[0]));
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ForgePlayer player2 = new ForgePlayer(serverPlayer, this);
        this.onlinePlayerMap.put(player2.getUuid(), player2);
        this.onlinePlayerList.add(player2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent evt) {
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        UUID playerUUID = player.getUUID();
        this.onlinePlayerMap.remove(playerUUID);
        List<ForgePlayer> list = this.onlinePlayerList;
        synchronized (list) {
            this.onlinePlayerList.removeIf(p -> p.getUuid().equals(playerUUID));
        }
    }

    public MinecraftServer getServer() {
        return this.serverInstance;
    }

    public Plugin getPlugin() {
        return this.pluginInstance;
    }

    @Override
    public Collection<de.bluecolored.bluemap.common.serverinterface.Player> getOnlinePlayers() {
        return this.onlinePlayerMap.values();
    }

    private void updateSomePlayers() {
        int onlinePlayerCount = this.onlinePlayerList.size();
        if (onlinePlayerCount == 0) {
            return;
        }
        int playersToBeUpdated = onlinePlayerCount / 20;
        if (playersToBeUpdated == 0) {
            playersToBeUpdated = 1;
        }
        for (int i = 0; i < playersToBeUpdated; ++i) {
            ++this.playerUpdateIndex;
            if (this.playerUpdateIndex >= 20 && this.playerUpdateIndex >= onlinePlayerCount) {
                this.playerUpdateIndex = 0;
            }
            if (this.playerUpdateIndex >= onlinePlayerCount) continue;
            this.onlinePlayerList.get(this.playerUpdateIndex).update();
        }
    }
}

