/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.BlueMapService;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapPurgeTask;
import de.bluecolored.bluemap.common.rendermanager.MapRenderTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.shadow.adventure.adventure.text.Component;
import de.bluecolored.shadow.adventure.adventure.text.ComponentLike;
import de.bluecolored.shadow.adventure.adventure.text.JoinConfiguration;
import de.bluecolored.shadow.adventure.adventure.text.TextComponent;
import de.bluecolored.shadow.adventure.adventure.text.event.HoverEvent;
import de.bluecolored.shadow.adventure.adventure.text.format.StyleSetter;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class StatusCommand {
    private final Plugin plugin;

    @Command(value={""})
    @Permission(value="bluemap.status")
    public Component status() {
        Status status = new Status();
        return status.status();
    }

    public StatusCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    private class Status {
        private final Map<String, BmMap> maps;
        private final List<RenderTask> renderQueue;
        @Nullable
        private final RenderTask currentTask;
        private final long currentTaskEta;
        private final long lastTimeBusy;
        private final boolean isRunning;
        private final boolean isPaused;
        private final boolean isProcessing;
        private final int workerThreadCount;
        private final int pausePlayerCount;

        public Status() {
            BlueMapService blueMapService = StatusCommand.this.plugin.getBlueMap();
            RenderManager renderManager = StatusCommand.this.plugin.getRenderManager();
            this.maps = blueMapService.getMaps();
            this.renderQueue = renderManager.getScheduledRenderTasks();
            this.currentTask = renderManager.getCurrentRenderTask();
            this.currentTaskEta = renderManager.estimateCurrentRenderTaskTimeRemaining();
            this.lastTimeBusy = renderManager.getLastTimeBusy();
            this.isRunning = StatusCommand.this.plugin.getPluginState().isRenderThreadsEnabled();
            this.isPaused = StatusCommand.this.plugin.checkPausedByPlayerCount();
            this.isProcessing = this.isRunning && !this.isPaused && this.currentTask != null;
            this.workerThreadCount = renderManager.getWorkerThreadCount();
            this.pausePlayerCount = blueMapService.getConfig().getPluginConfig().getPlayerRenderLimit();
        }

        public Component status() {
            return TextFormat.paragraph("Status", TextFormat.lines(this.renderThreads(), this.isProcessing ? this.activeTask() : null, this.mapSummary(this.isProcessing)));
        }

        private Component renderThreads() {
            if (!this.isRunning) {
                return TextFormat.lines(TextFormat.format("\u274c render-threads are %", Component.text("stopped").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.NEGATIVE_COLOR), TextFormat.details(TextFormat.BASE_COLOR, TextFormat.format((Component)Component.text("use % to start rendering"), TextFormat.command("/bluemap start").color(TextFormat.HIGHLIGHT_COLOR))));
            }
            if (this.isPaused) {
                return TextFormat.lines(TextFormat.format("\u231b render-threads are %", Component.text("paused").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.INFO_COLOR), TextFormat.details(TextFormat.BASE_COLOR, TextFormat.format((Component)Component.text("there are % or more players online"), Component.text(this.pausePlayerCount).color(TextFormat.HIGHLIGHT_COLOR))));
            }
            if (!this.isProcessing && this.lastTimeBusy > 1000L) {
                return TextFormat.lines(TextFormat.format(this.workerThreadCount == 1 ? "\u2714 % render-thread is %" : "\u2714 % render-threads are %", Component.text(this.workerThreadCount).color(TextFormat.HIGHLIGHT_COLOR), Component.text("idle").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.POSITIVE_COLOR), TextFormat.details(TextFormat.BASE_COLOR, TextFormat.format((Component)Component.text("last active % ago"), TextFormat.durationFormat(Instant.ofEpochMilli(this.lastTimeBusy)))));
            }
            return TextFormat.lines(TextFormat.format(this.workerThreadCount == 1 ? "\u2714 % render-thread is %" : "\u2714 % render-threads are %", Component.text(this.workerThreadCount).color(TextFormat.HIGHLIGHT_COLOR), Component.text(this.isProcessing ? "running" : "idle").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.POSITIVE_COLOR));
        }

        @Nullable
        private Component activeTask() {
            if (this.currentTask == null) {
                return null;
            }
            RenderTask renderTask = this.currentTask;
            Objects.requireNonNull(renderTask);
            RenderTask renderTask2 = renderTask;
            int n = 0;
            StyleSetter infoLine = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MapUpdateTask.class, WorldRegionRenderTask.class, MapPurgeTask.class}, (Object)renderTask2, n)) {
                case 0 -> {
                    MapUpdateTask t = (MapUpdateTask)renderTask2;
                    yield TextFormat.format("\u26cf map % is currently being updated", TextFormat.formatMap(t.getMap()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.INFO_COLOR);
                }
                case 1 -> {
                    WorldRegionRenderTask t = (WorldRegionRenderTask)renderTask2;
                    yield TextFormat.format("\u26cf map % is currently being updated", TextFormat.formatMap(t.getMap()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.INFO_COLOR);
                }
                case 2 -> {
                    MapPurgeTask t = (MapPurgeTask)renderTask2;
                    yield TextFormat.format("\u26cf map % is currently being purged", TextFormat.formatMap(t.getMap()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.INFO_COLOR);
                }
                default -> TextFormat.format("\u26cf currently running: %", Component.text(this.currentTask.getDescription()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.INFO_COLOR);
            }).hoverEvent(HoverEvent.showText(Component.text(this.currentTask.getDescription())));
            return TextFormat.lines(new Component[]{Component.empty(), infoLine, TextFormat.details(TextFormat.BASE_COLOR, TextFormat.stripNulls(TextFormat.format("progress: %", Component.text(String.format("%.3f%%", this.currentTask.estimateProgress() * 100.0)).color(TextFormat.HIGHLIGHT_COLOR)), this.taskETA(), this.currentTask.getDetail().map(Component::text).orElse(null))), Component.empty()});
        }

        @Nullable
        private Component taskETA() {
            if (this.currentTask == null) {
                return null;
            }
            if (this.currentTaskEta == 0L) {
                return null;
            }
            double progress = this.currentTask.estimateProgress();
            if (progress < 0.001) {
                return null;
            }
            String duration = TextFormat.duration(Duration.ofMillis(this.currentTaskEta));
            return TextFormat.format("remaining time: %", Component.text(duration).color(TextFormat.HIGHLIGHT_COLOR));
        }

        private Component mapSummary(boolean excludeInProgress) {
            RenderTask renderTask;
            HashSet<BmMap> mapsUpdated = new HashSet<BmMap>(this.maps.values());
            HashSet<BmMap> mapsPending = new HashSet<BmMap>();
            HashSet<BmMap> mapsFrozen = new HashSet<BmMap>();
            for (RenderTask renderTask2 : this.renderQueue) {
                if (!(renderTask2 instanceof MapRenderTask)) continue;
                MapRenderTask mapTask = (MapRenderTask)renderTask2;
                mapsPending.add(mapTask.getMap());
                mapsUpdated.remove(mapTask.getMap());
            }
            for (BmMap map : mapsUpdated) {
                if (StatusCommand.this.plugin.getPluginState().getMapState(map).isUpdateEnabled()) continue;
                mapsFrozen.add(map);
            }
            mapsUpdated.removeAll(mapsFrozen);
            if (excludeInProgress && (renderTask = this.currentTask) instanceof MapRenderTask) {
                MapRenderTask mapTask = (MapRenderTask)renderTask;
                mapsPending.remove(mapTask.getMap());
                mapsUpdated.remove(mapTask.getMap());
                mapsFrozen.remove(mapTask.getMap());
            }
            ArrayList<Component> lines = new ArrayList<Component>();
            if (!mapsPending.isEmpty()) {
                lines.add(this.formatMapSummary(mapsPending, "\u231b map % has pending updates", "\u231b % maps have pending updates").color(TextFormat.INFO_COLOR));
            }
            if (!mapsUpdated.isEmpty()) {
                lines.add(this.formatMapSummary(mapsUpdated, "\u2714 map % is updated", "\u2714 % maps are updated").color(TextFormat.POSITIVE_COLOR));
            }
            if (!mapsFrozen.isEmpty()) {
                lines.add(this.formatMapSummary(mapsFrozen, "\u2744 map % is frozen", "\u2744 % maps are frozen").color(TextFormat.FROZEN_COLOR));
            }
            return TextFormat.lines(lines);
        }

        private Component formatMapSummary(Collection<BmMap> maps, String single, String multiple) {
            if (maps.size() == 1) {
                return TextFormat.format(single, TextFormat.formatMap(maps.iterator().next()).color(TextFormat.HIGHLIGHT_COLOR));
            }
            if (maps.size() <= 10) {
                return TextFormat.format(multiple, ((TextComponent)Component.text(maps.size()).color(TextFormat.HIGHLIGHT_COLOR)).hoverEvent(HoverEvent.showText(Component.join(JoinConfiguration.separator(Component.text(", ").color(TextFormat.BASE_COLOR)), (ComponentLike[])maps.stream().map(BmMap::getId).map(id -> (TextComponent)Component.text(id).color(TextFormat.HIGHLIGHT_COLOR)).toArray(Component[]::new)))));
            }
            return TextFormat.format(multiple, ((TextComponent)Component.text(maps.size()).color(TextFormat.HIGHLIGHT_COLOR)).hoverEvent(HoverEvent.showText(Component.join(JoinConfiguration.separator(Component.text(", ").color(TextFormat.BASE_COLOR)), (ComponentLike[])maps.stream().limit(10L).map(BmMap::getId).map(id -> (TextComponent)Component.text(id).color(TextFormat.HIGHLIGHT_COLOR)).toArray(Component[]::new)).append(Component.text("...").color(TextFormat.BASE_COLOR)))));
        }
    }
}

