/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.map.mask.Mask;
import de.bluecolored.bluemap.core.util.Grid;
import java.util.function.Predicate;

public interface RenderSettings {
    public int getRemoveCavesBelowY();

    public int getCaveDetectionOceanFloor();

    public boolean isCaveDetectionUsesBlockLight();

    public float getAmbientLight();

    default public boolean isRenderEdges() {
        return true;
    }

    default public int getEdgeLightStrength() {
        return 15;
    }

    default public boolean isIgnoreMissingLightData() {
        return false;
    }

    public Mask getRenderMask();

    default public boolean isInsideRenderBoundaries(int x, int z) {
        return this.getRenderMask().test(x, Integer.MIN_VALUE, z, x, Integer.MAX_VALUE, z).getOr(true);
    }

    default public boolean isInsideRenderBoundaries(int x, int y, int z) {
        return this.getRenderMask().test(x, y, z);
    }

    default public boolean isInsideRenderBoundaries(Vector2i cell, Grid grid, boolean allowPartiallyIncludedCells) {
        return this.getRenderMask().test(grid.getCellMinX(cell.getX()), Integer.MIN_VALUE, grid.getCellMinY(cell.getY()), grid.getCellMaxX(cell.getX()), Integer.MAX_VALUE, grid.getCellMaxY(cell.getY())).getOr(allowPartiallyIncludedCells);
    }

    default public Predicate<Vector2i> getCellRenderBoundariesFilter(Grid grid, boolean allowPartiallyIncludedCells) {
        return cell -> this.isInsideRenderBoundaries((Vector2i)cell, grid, allowPartiallyIncludedCells);
    }

    public boolean isSaveHiresLayer();

    public boolean isRenderTopOnly();
}

