/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.mask;

import de.bluecolored.bluemap.core.util.Tristate;

public interface Mask {
    public static final Mask NONE = new Mask(){

        @Override
        public boolean test(int x, int y, int z) {
            return false;
        }

        @Override
        public Tristate test(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            return Tristate.FALSE;
        }

        @Override
        public boolean isEdge(int minX, int minZ, int maxX, int maxZ) {
            return false;
        }
    };
    public static final Mask ALL = NONE.inverted();

    public boolean test(int var1, int var2, int var3);

    public Tristate test(int var1, int var2, int var3, int var4, int var5, int var6);

    public boolean isEdge(int var1, int var2, int var3, int var4);

    default public Mask submask(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Tristate test = this.test(minX, minY, minZ, maxX, maxY, maxZ);
        if (test == Tristate.TRUE) {
            return ALL;
        }
        if (test == Tristate.FALSE) {
            return NONE;
        }
        return this;
    }

    default public Mask inverted() {
        return new Mask(){

            @Override
            public boolean test(int x, int y, int z) {
                return !Mask.this.test(x, y, z);
            }

            @Override
            public Tristate test(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
                return Mask.this.test(minX, minY, minZ, maxX, maxY, maxZ).negated();
            }

            @Override
            public boolean isEdge(int minX, int minZ, int maxX, int maxZ) {
                return Mask.this.isEdge(minX, minZ, maxX, maxZ);
            }

            @Override
            public Mask inverted() {
                return Mask.this;
            }
        };
    }
}

