/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.region;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.world.ChunkConsumer;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.bluemap.core.world.mca.ChunkLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;

public class LinearRegion<T>
implements Region<T> {
    public static final String FILE_SUFFIX = ".linear";
    public static final Pattern FILE_PATTERN = Pattern.compile("^r\\.(-?\\d+)\\.(-?\\d+)\\.linear$");
    private static final long MAGIC = -4323716122432332390L;
    private final ChunkLoader<T> chunkLoader;
    private final Path regionFile;
    private final Vector2i regionPos;
    private boolean initialized = false;
    private byte version;
    private long newestTimestamp;
    private byte compressionLevel;
    private short chunkCount;
    private int dataLength;
    private long dataHash;
    private byte[] compressedData;

    public LinearRegion(ChunkLoader<T> chunkLoader, Path regionFile) throws IllegalArgumentException {
        this.chunkLoader = chunkLoader;
        this.regionFile = regionFile;
        String[] filenameParts = regionFile.getFileName().toString().split("\\.");
        int rX = Integer.parseInt(filenameParts[1]);
        int rZ = Integer.parseInt(filenameParts[2]);
        this.regionPos = new Vector2i(rX, rZ);
    }

    private synchronized void init() throws IOException {
        if (this.initialized) {
            return;
        }
        if (Files.notExists(this.regionFile, new LinkOption[0])) {
            return;
        }
        long fileLength = Files.size(this.regionFile);
        if (fileLength == 0L) {
            return;
        }
        try (InputStream in = Files.newInputStream(this.regionFile, StandardOpenOption.READ);
             BufferedInputStream bIn = new BufferedInputStream(in);
             DataInputStream dIn = new DataInputStream(bIn);){
            if (dIn.readLong() != -4323716122432332390L) {
                throw new IOException("Linear region-file format: invalid header magic");
            }
            this.version = dIn.readByte();
            this.newestTimestamp = dIn.readLong();
            this.compressionLevel = dIn.readByte();
            this.chunkCount = dIn.readShort();
            this.dataLength = dIn.readInt();
            this.dataHash = dIn.readLong();
            if (this.version < 1 || this.version > 2) {
                throw new IOException("Linear region-file format: Unsupported version: " + this.version);
            }
            if (fileLength != (long)(this.dataLength + 40)) {
                throw new IOException("Linear region-file format: Invalid file length. Expected " + (this.dataLength + 40) + " but got " + fileLength);
            }
            this.compressedData = new byte[this.dataLength];
            dIn.readFully(this.compressedData, 0, this.dataLength);
            if (dIn.readLong() != -4323716122432332390L) {
                throw new IOException("Linear region-file format: invalid footer magic");
            }
        }
        this.initialized = true;
    }

    @Override
    public void iterateAllChunks(ChunkConsumer<T> consumer) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        int chunkStartX = this.regionPos.getX() * 32;
        int chunkStartZ = this.regionPos.getY() * 32;
        byte[] chunkDataBuffer = null;
        try (InputStream in = Compression.ZSTD.decompress(new ByteArrayInputStream(this.compressedData));
             DataInputStream dIn = new DataInputStream(in);){
            int i;
            int[] chunkDataLengths = new int[1024];
            int[] chunkTimestamps = new int[1024];
            for (i = 0; i < 1024; ++i) {
                chunkDataLengths[i] = dIn.readInt();
                chunkTimestamps[i] = dIn.readInt();
            }
            i = 0;
            int toBeSkipped = 0;
            for (int z = 0; z < 32; ++z) {
                for (int x = 0; x < 32; ++x) {
                    int length = chunkDataLengths[i];
                    if (length > 0) {
                        int timestamp;
                        int chunkX = chunkStartX + x;
                        int chunkZ = chunkStartZ + z;
                        int n = timestamp = this.version == 2 ? chunkTimestamps[i] : (int)this.newestTimestamp;
                        if (consumer.filter(chunkX, chunkZ, timestamp)) {
                            if (toBeSkipped > 0) {
                                LinearRegion.skipNBytes(dIn, toBeSkipped);
                            }
                            if (chunkDataBuffer == null || chunkDataBuffer.length < length) {
                                chunkDataBuffer = new byte[length];
                            }
                            dIn.readFully(chunkDataBuffer, 0, length);
                            try {
                                T chunk = this.chunkLoader.load(chunkDataBuffer, 0, length, Compression.NONE);
                                consumer.accept(chunkX, chunkZ, chunk);
                            }
                            catch (IOException ex) {
                                consumer.fail(chunkX, chunkZ, ex);
                            }
                            catch (Exception ex) {
                                consumer.fail(chunkX, chunkZ, new IOException(ex));
                            }
                        } else {
                            toBeSkipped += length;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public T emptyChunk() {
        return this.chunkLoader.emptyChunk();
    }

    public static String getRegionFileName(int regionX, int regionZ) {
        return "r." + regionX + "." + regionZ + FILE_SUFFIX;
    }

    private static void skipNBytes(InputStream in, long n) throws IOException {
        while (n > 0L) {
            long ns = in.skip(n);
            if (ns > 0L && ns <= n) {
                n -= ns;
                continue;
            }
            if (ns == 0L) {
                if (in.read() == -1) {
                    throw new EOFException();
                }
                --n;
                continue;
            }
            throw new IOException("Unable to skip exactly");
        }
    }

    public ChunkLoader<T> getChunkLoader() {
        return this.chunkLoader;
    }

    public Path getRegionFile() {
        return this.regionFile;
    }

    public Vector2i getRegionPos() {
        return this.regionPos;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public byte getVersion() {
        return this.version;
    }

    public long getNewestTimestamp() {
        return this.newestTimestamp;
    }

    public byte getCompressionLevel() {
        return this.compressionLevel;
    }

    public short getChunkCount() {
        return this.chunkCount;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public long getDataHash() {
        return this.dataHash;
    }

    public byte[] getCompressedData() {
        return this.compressedData;
    }
}

