/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands;

import de.bluecolored.bluecommands.CommandExecutable;
import de.bluecolored.bluecommands.CommandSetupException;
import de.bluecolored.bluecommands.InputReader;
import de.bluecolored.bluecommands.ParseData;
import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.ParseMatch;
import de.bluecolored.bluecommands.ParseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class Command<C, T> {
    private final Collection<Command<C, T>> subCommands = new ArrayList<Command<C, T>>(1);
    @Nullable
    private CommandExecutable<C, T> executable = null;
    private transient C lastValidationContext;
    private transient boolean lastValidationResult;
    private transient long lastValidationTime;
    private transient boolean lastTreeOptionalResult;
    private transient long lastTreeOptionalTime;

    @Nullable
    public CommandExecutable<C, T> getExecutable() {
        return this.executable;
    }

    public void setExecutable(@Nullable CommandExecutable<C, T> executable) {
        this.executable = executable;
    }

    public Collection<Command<C, T>> getSubCommands() {
        return this.subCommands;
    }

    public ParseResult<C, T> parse(C context, String input) {
        return this.parse(context, new InputReader(input));
    }

    public ParseResult<C, T> parse(C context, InputReader input) {
        ParseData stack = new ParseData(context, input, this);
        this.parse(stack);
        return stack.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(ParseData<C, T> data) {
        if (!this.isValid(data.getContext())) {
            return;
        }
        InputReader input = data.getInput();
        int inputPosition = input.getPosition();
        if (this.executable != null && this.executable.isValid(data.getContext())) {
            if (input.peek() == -1) {
                data.getResult().addMatch(new ParseMatch<C, T>(this.executable, data.getContext(), data.getArguments(), data.getCommandStack()));
            } else {
                data.getResult().addFailure(new ParseFailure<C, T>(inputPosition, "Too many arguments.", data.getCommandStack()));
            }
        }
        if (this.getClass() == Command.class || inputPosition == 0 || input.read() == 32) {
            for (Command<C, T> subCommand : this.subCommands) {
                try {
                    data.pushSegment(subCommand);
                    subCommand.parse(data);
                }
                finally {
                    data.popSegment();
                }
            }
        } else if (!this.subCommands.isEmpty()) {
            if (this.isSubTreeOptional()) {
                this.gatherAllExecutables(data.getContext(), executable -> data.getResult().addMatch(new ParseMatch(executable, data.getContext(), data.getArguments(), data.getCommandStack())));
            } else {
                data.getResult().addFailure(new ParseFailure<C, T>(inputPosition, "Not enough arguments!", data.getCommandStack()));
            }
        }
    }

    public boolean isOptional() {
        return false;
    }

    private void gatherAllExecutables(C context, Consumer<CommandExecutable<C, T>> consumer) {
        if (this.executable != null && this.isValid(context)) {
            consumer.accept(this.executable);
        }
        for (Command<C, CommandExecutable<C, T>> command : this.subCommands) {
            command.gatherAllExecutables(context, consumer);
        }
    }

    private boolean isSubTreeOptional() {
        for (Command<C, T> subCommand : this.subCommands) {
            if (subCommand.isTreeOptional()) continue;
            return false;
        }
        return true;
    }

    private boolean isTreeOptional() {
        long now = System.currentTimeMillis();
        if (this.lastTreeOptionalTime < now - 1000L) {
            this.lastTreeOptionalResult = this.checkTreeOptional();
            this.lastTreeOptionalTime = now;
        }
        return this.lastTreeOptionalResult;
    }

    private boolean checkTreeOptional() {
        if (!this.isOptional()) {
            return false;
        }
        for (Command<C, T> subCommand : this.subCommands) {
            if (subCommand.isTreeOptional()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean isValid(C context) {
        long now = System.currentTimeMillis();
        if (this.lastValidationTime < now - 1000L || this.lastValidationContext == null || !this.lastValidationContext.equals(context)) {
            this.lastValidationResult = this.checkValid(context);
            this.lastValidationContext = context;
            this.lastValidationTime = now;
        }
        return this.lastValidationResult;
    }

    private boolean checkValid(C context) {
        if (this.executable != null && this.executable.isValid(context)) {
            return true;
        }
        for (Command<C, T> subCommand : this.subCommands) {
            if (!subCommand.isValid(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isEqual(Command<C, T> other) {
        return this.getClass() == other.getClass();
    }

    public boolean tryMerge(Command<C, T> other) {
        if (!this.isEqual(other)) {
            return false;
        }
        this.merge(other);
        return true;
    }

    private void merge(Command<C, T> other) {
        if (other.executable != null) {
            if (this.executable != null) {
                throw new CommandSetupException("Ambiguous command executable!");
            }
            this.executable = other.executable;
        }
        for (Command<C, T> otherSubCommand : other.subCommands) {
            this.addSubCommand(otherSubCommand);
        }
    }

    public void addSubCommand(Command<C, T> subCommand) {
        if (subCommand.getClass() == Command.class) {
            this.merge(subCommand);
            return;
        }
        boolean merged = false;
        for (Command<C, T> thisSubCommand : this.subCommands) {
            if (!thisSubCommand.tryMerge(subCommand)) continue;
            merged = true;
            break;
        }
        if (!merged) {
            this.subCommands.add(subCommand);
        }
    }
}

