/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.bukkit;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.bukkit.BukkitPlugin;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.common.serverinterface.Gamemode;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffectType;

public class BukkitPlayer
extends de.bluecolored.bluemap.common.serverinterface.Player {
    private static final Map<GameMode, Gamemode> GAMEMODE_MAP = new EnumMap<GameMode, Gamemode>(GameMode.class);
    private final UUID uuid;
    private Text name;
    private ServerWorld world;
    private Vector3d position;
    private Vector3d rotation;
    private int skyLight;
    private int blockLight;
    private boolean sneaking;
    private boolean invisible;
    private boolean vanished;
    private Gamemode gamemode;

    public BukkitPlayer(Player player) {
        this.uuid = player.getUniqueId();
        this.update(player);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Text getName() {
        return this.name;
    }

    @Override
    public ServerWorld getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public Vector3d getRotation() {
        return this.rotation;
    }

    @Override
    public int getSkyLight() {
        return this.skyLight;
    }

    @Override
    public int getBlockLight() {
        return this.blockLight;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public boolean isInvisible() {
        return this.invisible;
    }

    @Override
    public boolean isVanished() {
        return this.vanished;
    }

    @Override
    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void update() {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player == null) {
            return;
        }
        this.update(player);
    }

    private void update(Player player) {
        this.gamemode = GAMEMODE_MAP.get(player.getGameMode());
        if (this.gamemode == null) {
            this.gamemode = Gamemode.SURVIVAL;
        }
        this.invisible = player.hasPotionEffect(PotionEffectType.INVISIBILITY);
        boolean vanished = false;
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            vanished = true;
        }
        this.vanished = vanished;
        this.name = Text.of(player.getName());
        Location location = player.getLocation();
        this.position = new Vector3d(location.getX(), location.getY(), location.getZ());
        this.rotation = new Vector3d(location.getPitch(), location.getYaw(), 0.0f);
        this.sneaking = player.isSneaking();
        this.skyLight = player.getLocation().getBlock().getLightFromSky();
        this.blockLight = player.getLocation().getBlock().getLightFromBlocks();
        this.world = BukkitPlugin.getInstance().getServerWorld(player.getWorld());
    }

    static {
        GAMEMODE_MAP.put(GameMode.ADVENTURE, Gamemode.ADVENTURE);
        GAMEMODE_MAP.put(GameMode.SURVIVAL, Gamemode.SURVIVAL);
        GAMEMODE_MAP.put(GameMode.CREATIVE, Gamemode.CREATIVE);
        GAMEMODE_MAP.put(GameMode.SPECTATOR, Gamemode.SPECTATOR);
    }
}

