/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.AssetStorage;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.common.api.AssetStorageImpl;
import de.bluecolored.bluemap.common.api.BlueMapWorldImpl;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.MapUpdatePreparationTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.map.BmMap;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class BlueMapMapImpl
implements BlueMapMap {
    private final String mapId;
    private final WeakReference<BmMap> map;
    private final BlueMapWorldImpl world;
    private final WeakReference<Plugin> plugin;

    public BlueMapMapImpl(BmMap map, BlueMapWorldImpl world, @Nullable Plugin plugin) {
        this.mapId = map.getId();
        this.map = new WeakReference<BmMap>(map);
        this.world = world;
        this.plugin = new WeakReference<Plugin>(plugin);
    }

    @Override
    public String getId() {
        return this.mapId;
    }

    @Override
    public String getName() {
        return this.unpack(this.map).getName();
    }

    @Override
    public BlueMapWorld getWorld() {
        return this.world;
    }

    @Override
    public AssetStorage getAssetStorage() {
        return new AssetStorageImpl(this.unpack(this.map).getStorage(), this.getId());
    }

    @Override
    public Map<String, MarkerSet> getMarkerSets() {
        return this.unpack(this.map).getMarkerSets();
    }

    @Override
    public Vector2i getTileSize() {
        return this.unpack(this.map).getHiresModelManager().getTileGrid().getGridSize();
    }

    @Override
    public Vector2i getTileOffset() {
        return this.unpack(this.map).getHiresModelManager().getTileGrid().getOffset();
    }

    @Override
    @Deprecated(forRemoval=true)
    public void setTileFilter(@NonNull Predicate<Vector2i> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        this.unpack(this.map).setTileFilter(filter);
    }

    @Override
    @Deprecated(forRemoval=true)
    public Predicate<Vector2i> getTileFilter() {
        return this.unpack(this.map).getTileFilter();
    }

    @Override
    public synchronized void setFrozen(boolean frozen) {
        if (frozen != this.isFrozen()) {
            if (frozen) {
                this.freeze();
            } else {
                this.unfreeze();
            }
        }
    }

    private synchronized void unfreeze() {
        Plugin plugin = (Plugin)this.plugin.get();
        if (plugin == null) {
            return;
        }
        BmMap map = this.unpack(this.map);
        plugin.startWatchingMap(map);
        plugin.getPluginState().getMapState(map).setUpdateEnabled(true);
        plugin.getRenderManager().scheduleRenderTaskNext(MapUpdatePreparationTask.updateMap(map, plugin.getRenderManager()));
    }

    private synchronized void freeze() {
        Plugin plugin = (Plugin)this.plugin.get();
        if (plugin == null) {
            return;
        }
        BmMap map = this.unpack(this.map);
        plugin.stopWatchingMap(map);
        plugin.getPluginState().getMapState(map).setUpdateEnabled(false);
        plugin.getRenderManager().removeRenderTasksIf(task -> {
            if (task instanceof MapUpdateTask) {
                return ((MapUpdateTask)task).getMap().equals(map);
            }
            if (task instanceof WorldRegionRenderTask) {
                return ((WorldRegionRenderTask)task).getMap().equals(map);
            }
            return false;
        });
    }

    @Override
    public boolean isFrozen() {
        Plugin plugin = (Plugin)this.plugin.get();
        if (plugin == null) {
            return false;
        }
        return !plugin.getPluginState().getMapState(this.unpack(this.map)).isUpdateEnabled();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlueMapMapImpl that = (BlueMapMapImpl)o;
        return this.mapId.equals(that.mapId);
    }

    public int hashCode() {
        return this.mapId.hashCode();
    }

    private <T> T unpack(WeakReference<T> ref) {
        return Objects.requireNonNull(ref.get(), "Reference lost to delegate object. Most likely BlueMap got reloaded and this instance is no longer valid.");
    }

    public BmMap map() {
        return this.unpack(this.map);
    }
}

