/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluecommands.annotations.Parser;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.config.BlueMapConfigManager;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.storage.FileConfig;
import de.bluecolored.bluemap.common.config.storage.SQLConfig;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.StorageDeleteTask;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.storage.file.FileStorage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

public class StoragesCommand {
    private final Plugin plugin;

    @Command(value={"storages"})
    @Permission(value="bluemap.storages")
    public Component storageList() {
        Map<String, Storage> loadedStorages = this.plugin.getBlueMap().getLoadedStorages();
        Component[] lines = (Component[])this.plugin.getBlueMap().getConfig().getStorageConfigs().entrySet().stream().map(storage -> this.formatStorageEntry((String)storage.getKey(), (StorageConfig)storage.getValue(), loadedStorages.containsKey(storage.getKey()))).toArray(Component[]::new);
        return TextFormat.paragraph("Storages", TextFormat.lines(lines));
    }

    private Component formatStorageEntry(String id, StorageConfig storage, boolean loaded) {
        Component loadedIcon = loaded ? Component.text((String)"\u2714").color(TextFormat.POSITIVE_COLOR) : Component.text((String)"\u274c").color(TextFormat.BASE_COLOR);
        return TextFormat.format("% %", loadedIcon, Component.text((String)id).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR);
    }

    @Command(value={"storages <storage>"})
    @Permission(value="bluemap.storages")
    public Component storage(CommandSource source, @Argument(value="storage") @Parser(value="storage-id") String storageId) throws ConfigurationException, InterruptedException, IOException {
        StorageConfig storageConfig = this.plugin.getBlueMap().getConfig().getStorageConfigs().get(storageId);
        Storage storage = this.getOrLoadStorage(storageId, source);
        LinkedList<Component> lines = new LinkedList<Component>();
        lines.add(TextFormat.format("Type: %", Component.text((String)storageConfig.getStorageType().getKey().getFormatted()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        if (storage instanceof FileStorage) {
            FileStorage fileStorage = (FileStorage)storage;
            lines.add(TextFormat.format("Path: %", Component.text((String)BlueMapConfigManager.formatPath(fileStorage.getRoot())).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        }
        if (storageConfig instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)storageConfig;
            lines.add(TextFormat.format("Compression: %", Component.text((String)fileConfig.getCompression().getKey().getFormatted()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        }
        if (storageConfig instanceof SQLConfig) {
            SQLConfig sqlConfig = (SQLConfig)storageConfig;
            lines.add(TextFormat.format("Dialect: %", Component.text((String)sqlConfig.getDialect().getKey().getFormatted()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
            lines.add(TextFormat.format("Compression: %", Component.text((String)sqlConfig.getCompression().getKey().getFormatted()).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        }
        lines.add((Component)Component.empty());
        lines.add(Component.text((String)"Maps:").color(TextFormat.BASE_COLOR));
        storage.mapIds().limit(20L).map(mapId -> this.formatMapEntry((String)mapId, storage)).forEach(lines::add);
        return TextFormat.paragraph("Storage '%s'".formatted(storageId), TextFormat.lines(lines));
    }

    @Command(value={"storages <storage> delete <map>"})
    @Permission(value="bluemap.storages.delete")
    public void deleteMap(CommandSource source, @Argument(value="storage") @Parser(value="storage-id") String storageId, @Argument(value="map") String mapId) throws ConfigurationException, InterruptedException {
        Storage storage = this.getOrLoadStorage(storageId, source);
        if (this.isMapLoaded(mapId, storage)) {
            source.sendMessage(((TextComponent)Component.text((String)"Can't delete a loaded map!").color(TextFormat.NEGATIVE_COLOR)).append(TextFormat.format("Unload the map by removing it's config-file first,\nor use % if you want to purge it.\n".strip(), TextFormat.command("/bluemap purge " + mapId).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR)));
            return;
        }
        StorageDeleteTask task = new StorageDeleteTask(storage.map(mapId), mapId);
        this.plugin.getRenderManager().scheduleRenderTaskNext(task);
        source.sendMessage(TextFormat.lines(TextFormat.format("Scheduled a new task to delete map % from storage %", Component.text((String)mapId).color(TextFormat.HIGHLIGHT_COLOR), Component.text((String)storageId).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.POSITIVE_COLOR), TextFormat.format("Use % to see the progress", TextFormat.command("/bluemap").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR)));
    }

    private Storage getOrLoadStorage(String storageId, CommandSource source) throws ConfigurationException, InterruptedException {
        Map<String, Storage> loadedStorages = this.plugin.getBlueMap().getLoadedStorages();
        Storage storage = loadedStorages.get(storageId);
        if (storage != null) {
            return storage;
        }
        source.sendMessage(TextFormat.format("Initializing storage '%'...", storageId).color(TextFormat.BASE_COLOR));
        return this.plugin.getBlueMap().getOrLoadStorage(storageId);
    }

    private boolean isMapLoaded(String mapId, Storage storage) {
        BmMap map = this.plugin.getBlueMap().getMaps().get(mapId);
        return map != null && map.getStorage().equals(storage.map(mapId));
    }

    private Component formatMapEntry(String id, Storage storage) {
        Component loadedIcon = this.isMapLoaded(id, storage) ? Component.text((String)"\u2714").color(TextFormat.POSITIVE_COLOR) : Component.text((String)"\u274c").color(TextFormat.BASE_COLOR);
        return TextFormat.format("% %", loadedIcon, Component.text((String)id).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR);
    }

    public StoragesCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

