/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config.typeserializer;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.shadow.configurate.ConfigurationNode;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import de.bluecolored.shadow.configurate.serialize.TypeSerializer;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;

public class Vector2iTypeSerializer
implements TypeSerializer<Vector2i> {
    @Override
    public Vector2i deserialize(Type type, ConfigurationNode node) throws SerializationException {
        ConfigurationNode xNode = node.node("x");
        ConfigurationNode yNode = node.node("y");
        if (yNode.virtual()) {
            yNode = node.node("z");
        }
        if (xNode.virtual() || yNode.virtual()) {
            throw new SerializationException("Cannot parse Vector2i: value x or y missing");
        }
        return Vector2i.from((int)xNode.getInt(), (int)yNode.getInt());
    }

    @Override
    public void serialize(Type type, @Nullable Vector2i obj, ConfigurationNode node) throws SerializationException {
        if (obj != null) {
            node.node("x").set(obj.getX());
            node.node("y").set(obj.getY());
        }
    }
}

