/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.api.ContentTypeRegistry;
import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.MapStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public class MapStorageRequestHandler
implements HttpRequestHandler {
    private static final Pattern TILE_PATTERN = Pattern.compile("tiles/([\\d/]+)/x(-?[\\d/]+)z(-?[\\d/]+).*");
    @NonNull
    private MapStorage mapStorage;

    @Override
    public HttpResponse handle(HttpRequest request) {
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            CompressedInputStream in;
            Matcher tileMatcher = TILE_PATTERN.matcher(path);
            if (tileMatcher.matches()) {
                int z;
                int x;
                int lod = Integer.parseInt(tileMatcher.group(1));
                GridStorage gridStorage = lod == 0 ? this.mapStorage.hiresTiles() : this.mapStorage.lowresTiles(lod);
                CompressedInputStream in2 = gridStorage.read(x = Integer.parseInt(tileMatcher.group(2).replace("/", "")), z = Integer.parseInt(tileMatcher.group(3).replace("/", "")));
                if (in2 == null) {
                    return new HttpResponse(HttpStatusCode.NO_CONTENT);
                }
                HttpResponse response = new HttpResponse(HttpStatusCode.OK);
                response.addHeader("Cache-Control", "public");
                response.addHeader("Cache-Control", "max-age=" + TimeUnit.DAYS.toSeconds(1L));
                if (lod == 0) {
                    response.addHeader("Content-Type", "application/octet-stream");
                } else {
                    response.addHeader("Content-Type", "image/png");
                }
                this.writeToResponse(in2, response, request);
                return response;
            }
            switch (path) {
                case "settings.json": {
                    CompressedInputStream compressedInputStream = this.mapStorage.settings().read();
                    break;
                }
                case "textures.json": {
                    CompressedInputStream compressedInputStream = this.mapStorage.textures().read();
                    break;
                }
                case "live/markers.json": {
                    CompressedInputStream compressedInputStream = this.mapStorage.markers().read();
                    break;
                }
                case "live/players.json": {
                    CompressedInputStream compressedInputStream = this.mapStorage.players().read();
                    break;
                }
                default: {
                    CompressedInputStream compressedInputStream = in = path.startsWith("assets/") ? this.mapStorage.asset(path.substring(7)).read() : null;
                }
            }
            if (in != null) {
                HttpResponse response = new HttpResponse(HttpStatusCode.OK);
                response.addHeader("Cache-Control", "public");
                response.addHeader("Cache-Control", "max-age=" + TimeUnit.DAYS.toSeconds(1L));
                response.addHeader("Content-Type", ContentTypeRegistry.fromFileName(path));
                this.writeToResponse(in, response, request);
                return response;
            }
        }
        catch (NumberFormatException | NoSuchElementException tileMatcher) {
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to read map-tile for web-request.", ex);
            return new HttpResponse(HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
        return new HttpResponse(HttpStatusCode.NOT_FOUND);
    }

    private void writeToResponse(CompressedInputStream data, HttpResponse response, HttpRequest request) throws IOException {
        Compression compression = data.getCompression();
        if (compression != Compression.NONE && request.hasHeaderValue("Accept-Encoding", compression.getId())) {
            response.addHeader("Content-Encoding", compression.getId());
            response.setData(data);
        } else if (compression != Compression.GZIP && !response.hasHeaderValue("Content-Type", "image/png") && request.hasHeaderValue("Accept-Encoding", Compression.GZIP.getId())) {
            response.addHeader("Content-Encoding", Compression.GZIP.getId());
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try (CompressedInputStream compressedInputStream = data;
                 OutputStream os = Compression.GZIP.compress(byteOut);){
                data.decompress().transferTo(os);
            }
            byte[] compressedData = byteOut.toByteArray();
            response.setData(new ByteArrayInputStream(compressedData));
        } else {
            response.setData(data.decompress());
        }
    }

    public MapStorageRequestHandler(@NonNull MapStorage mapStorage) {
        if (mapStorage == null) {
            throw new NullPointerException("mapStorage is marked non-null but is null");
        }
        this.mapStorage = mapStorage;
    }

    @NonNull
    public MapStorage getMapStorage() {
        return this.mapStorage;
    }

    public void setMapStorage(@NonNull MapStorage mapStorage) {
        if (mapStorage == null) {
            throw new NullPointerException("mapStorage is marked non-null but is null");
        }
        this.mapStorage = mapStorage;
    }
}

