/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate;

import de.bluecolored.bluemap.core.map.hires.block.BlockRendererType;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.adapter.PostDeserialize;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Model;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;

public class Variant {
    private BlockRendererType renderer = BlockRendererType.DEFAULT;
    private ResourcePath<Model> model = ResourcePack.MISSING_BLOCK_MODEL;
    private float x = 0.0f;
    private float y = 0.0f;
    private boolean uvlock = false;
    private double weight = 1.0;
    private transient boolean transformed;
    private transient MatrixM4f transformMatrix;

    public Variant(ResourcePath<Model> model) {
        this.model = model;
        this.init();
    }

    public Variant(ResourcePath<Model> model, float x, float y) {
        this.model = model;
        this.x = x;
        this.y = y;
        this.init();
    }

    public Variant(ResourcePath<Model> model, float x, float y, boolean uvlock, double weight) {
        this.model = model;
        this.x = x;
        this.y = y;
        this.uvlock = uvlock;
        this.weight = weight;
        this.init();
    }

    @PostDeserialize
    private void init() {
        this.transformed = this.x != 0.0f || this.y != 0.0f;
        this.transformMatrix = new MatrixM4f().translate(-0.5f, -0.5f, -0.5f).rotate(-this.x, -this.y, 0.0f).translate(0.5f, 0.5f, 0.5f);
    }

    public BlockRendererType getRenderer() {
        return this.renderer;
    }

    public ResourcePath<Model> getModel() {
        return this.model;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean isUvlock() {
        return this.uvlock;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public MatrixM4f getTransformMatrix() {
        return this.transformMatrix;
    }

    private Variant() {
    }

    public void setRenderer(BlockRendererType renderer) {
        this.renderer = renderer;
    }
}

