/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate;

import com.google.gson.Gson;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import de.bluecolored.bluemap.core.resources.adapter.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.BlockStateCondition;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.Variant;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;

@JsonAdapter(value=Adapter.class)
public class VariantSet {
    private BlockStateCondition condition;
    private Variant[] variants;
    private transient double totalWeight;

    public VariantSet(Variant ... variants) {
        this(BlockStateCondition.all(), variants);
    }

    public VariantSet(BlockStateCondition condition, Variant ... variants) {
        this.condition = condition;
        this.variants = variants;
        this.totalWeight = this.summarizeWeights();
    }

    public BlockStateCondition getCondition() {
        return this.condition;
    }

    public void setCondition(BlockStateCondition condition) {
        this.condition = condition;
    }

    public Variant[] getVariants() {
        return this.variants;
    }

    private double summarizeWeights() {
        return Arrays.stream(this.variants).mapToDouble(Variant::getWeight).sum();
    }

    public void forEach(Consumer<Variant> consumer) {
        for (Variant variant : this.variants) {
            consumer.accept(variant);
        }
    }

    public void forEach(int x, int y, int z, Consumer<Variant> consumer) {
        double selection = (double)VariantSet.hashToFloat(x, y, z) * this.totalWeight;
        for (Variant variant : this.variants) {
            if (!((selection -= variant.getWeight()) <= 0.0)) continue;
            consumer.accept(variant);
            return;
        }
    }

    private static float hashToFloat(int x, int y, int z) {
        long hash = (long)x * 73438747L ^ (long)y * 9357269L ^ (long)z * 4335792L;
        return (float)(hash * (hash + 456149L) & 0xFFFFFFL) / 1.6777216E7f;
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<VariantSet> {
        public Adapter() {
            super(VariantSet.class);
        }

        @Override
        public VariantSet read(JsonReader in, Gson gson) throws IOException {
            Variant[] variants = in.peek() == JsonToken.BEGIN_ARRAY ? (Variant[])gson.fromJson(in, Variant[].class) : new Variant[]{(Variant)gson.fromJson(in, Variant.class)};
            return new VariantSet(variants);
        }
    }
}

