/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage;

import de.bluecolored.bluemap.core.storage.ItemStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public interface GridStorage {
    public OutputStream write(int var1, int var2) throws IOException;

    @Nullable
    public CompressedInputStream read(int var1, int var2) throws IOException;

    public void delete(int var1, int var2) throws IOException;

    public boolean exists(int var1, int var2) throws IOException;

    public ItemStorage cell(int var1, int var2);

    public Stream<Cell> stream() throws IOException;

    public boolean isClosed();

    public static class GridStorageCell
    implements Cell {
        private final GridStorage storage;
        private final int x;
        private final int z;

        @Override
        public OutputStream write() throws IOException {
            return this.storage.write(this.x, this.z);
        }

        @Override
        public CompressedInputStream read() throws IOException {
            return this.storage.read(this.x, this.z);
        }

        @Override
        public void delete() throws IOException {
            this.storage.delete(this.x, this.z);
        }

        @Override
        public boolean exists() throws IOException {
            return this.storage.exists(this.x, this.z);
        }

        @Override
        public boolean isClosed() {
            return this.storage.isClosed();
        }

        public GridStorage getStorage() {
            return this.storage;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getZ() {
            return this.z;
        }

        public GridStorageCell(GridStorage storage, int x, int z) {
            this.storage = storage;
            this.x = x;
            this.z = z;
        }
    }

    public static interface Cell
    extends ItemStorage {
        public int getX();

        public int getZ();
    }
}

