/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.core.world.BlockEntity;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.biome.Biome;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public interface Chunk {
    public static final Chunk EMPTY_CHUNK = new Chunk(){};
    public static final Chunk ERRORED_CHUNK = new Chunk(){};

    default public boolean isGenerated() {
        return false;
    }

    default public boolean hasLightData() {
        return false;
    }

    default public long getInhabitedTime() {
        return 0L;
    }

    default public BlockState getBlockState(int x, int y, int z) {
        return BlockState.AIR;
    }

    default public LightData getLightData(int x, int y, int z, LightData target) {
        return target.set(0, 0);
    }

    default public Biome getBiome(int x, int y, int z) {
        return Biome.DEFAULT;
    }

    default public int getMaxY(int x, int z) {
        return 255;
    }

    default public int getMinY(int x, int z) {
        return 0;
    }

    default public boolean hasWorldSurfaceHeights() {
        return false;
    }

    default public int getWorldSurfaceY(int x, int z) {
        return 0;
    }

    default public boolean hasOceanFloorHeights() {
        return false;
    }

    default public int getOceanFloorY(int x, int z) {
        return 0;
    }

    @Nullable
    default public BlockEntity getBlockEntity(int x, int y, int z) {
        return null;
    }

    default public void iterateBlockEntities(Consumer<BlockEntity> consumer) {
    }
}

