/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.biome;

import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.biome.ColorModifier;
import de.bluecolored.bluemap.core.world.block.BlockAccess;

public interface GrassColorModifier
extends Keyed,
ColorModifier {
    public static final GrassColorModifier NONE = new Impl(Key.minecraft("none"), (block, color) -> {});
    public static final GrassColorModifier DARK_FOREST = new Impl(Key.minecraft("dark_forest"), (block, color) -> color.set((color.getInt() & 0xFEFEFE) + 2634762 >> 1 | 0xFF000000, true));
    public static final GrassColorModifier SWAMP = new Impl(Key.minecraft("swamp"), (block, color) -> color.set(-9801671, true));
    public static final Registry<GrassColorModifier> REGISTRY = new Registry((Keyed[])new GrassColorModifier[]{NONE, DARK_FOREST, SWAMP});

    public static class Impl
    implements GrassColorModifier {
        private final Key key;
        private final ColorModifier modifier;

        @Override
        public void apply(BlockAccess block, Color color) {
            this.modifier.apply(block, color);
        }

        public Impl(Key key, ColorModifier modifier) {
            this.key = key;
            this.modifier = modifier;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        public ColorModifier getModifier() {
            return this.modifier;
        }
    }
}

