/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.data;

import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TypeDeserializer;
import java.io.IOException;
import java.util.LinkedHashMap;

public class BlockStateDeserializer
implements TypeDeserializer<BlockState> {
    @Override
    public BlockState read(NBTReader reader) throws IOException {
        reader.beginCompound();
        String id = null;
        LinkedHashMap<String, String> properties = null;
        block8: while (reader.hasNext()) {
            switch (reader.name()) {
                case "Name": {
                    id = reader.nextString();
                    continue block8;
                }
                case "Properties": {
                    properties = new LinkedHashMap<String, String>();
                    reader.beginCompound();
                    while (reader.hasNext()) {
                        properties.put(reader.name(), reader.nextString());
                    }
                    reader.endCompound();
                    continue block8;
                }
            }
            reader.skip();
        }
        reader.endCompound();
        if (id == null) {
            throw new IOException("Invalid BlockState, Name is missing!");
        }
        Key key = Key.parse(id);
        return properties == null ? new BlockState(key) : new BlockState(key, properties);
    }
}

