/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.data;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluenbt.NBTReader;
import de.bluecolored.bluenbt.TagType;
import de.bluecolored.bluenbt.TypeDeserializer;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;

public class Vector2iDeserializer
implements TypeDeserializer<Vector2i> {
    @Override
    public Vector2i read(NBTReader reader) throws IOException {
        TagType tag;
        TagType tagType = tag = reader.peek();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INT_ARRAY", "LONG_ARRAY", "BYTE_ARRAY", "LIST", "COMPOUND"}, (TagType)tagType, n)) {
            case 0, 1, 2 -> {
                long[] values = reader.nextArrayAsLongArray();
                if (values.length != 2) {
                    throw new IllegalStateException("Unexpected array length: " + values.length);
                }
                yield new Vector2i((double)values[0], (double)values[1]);
            }
            case 3 -> {
                reader.beginList();
                Vector2i value = new Vector2i(reader.nextDouble(), reader.nextDouble());
                reader.endList();
                yield value;
            }
            case 4 -> {
                double x = 0.0;
                double y = 0.0;
                reader.beginCompound();
                block14: while (reader.peek() != TagType.END) {
                    switch (reader.name()) {
                        case "x": {
                            x = reader.nextDouble();
                            continue block14;
                        }
                        case "y": 
                        case "z": {
                            y = reader.nextDouble();
                            continue block14;
                        }
                    }
                    reader.skip();
                }
                reader.endCompound();
                yield new Vector2i(x, y);
            }
            default -> throw new IllegalStateException("Unexpected tag-type: " + String.valueOf((Object)tag));
        };
    }
}

