/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluenbt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

class DataLogInputStream
extends InputStream {
    protected final InputStream in;
    protected boolean isLogging;
    protected ByteArrayOutputStream log;

    public DataLogInputStream(InputStream in) {
        this.in = in;
        this.isLogging = false;
        this.log = new ByteArrayOutputStream();
    }

    public void startLog() {
        this.log.reset();
        this.isLogging = true;
    }

    public byte[] stopLog() {
        this.isLogging = false;
        return this.log.toByteArray();
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (this.isLogging && b != -1) {
            this.log.write(b);
        }
        return b;
    }

    @Override
    public int read(byte @NotNull [] b) throws IOException {
        int l = this.in.read(b);
        if (this.isLogging && l != -1) {
            this.log.write(b, 0, l);
        }
        return l;
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        int l = this.in.read(b, off, len);
        if (this.isLogging && l != -1) {
            this.log.write(b, off, l);
        }
        return l;
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        byte[] d = this.in.readNBytes(len);
        if (this.isLogging) {
            this.log.write(d, 0, Math.min(d.length, len));
        }
        return d;
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        int l = this.in.readNBytes(b, off, len);
        if (this.isLogging && l != -1) {
            this.log.write(b, off, l);
        }
        return l;
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.isLogging) {
            return this.in.skip(n);
        }
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

